﻿using System;
namespace gov.va.med.imaging.exchange.VixInstaller.business
{
    public interface IVixConfigurationParameters
    {
        string TomcatAdminPassword { get; set; }
        string BiaPassword { get; set; }
        string BiaUsername { get; set; }
        string ConfigDir { get; set; }
        string FederationKeystorePassword { get; set; }
        string FederationTruststorePassword { get; set; }
        bool HasLocalDodConfiguration();
        bool IsNewVixInstallation();
        string LocalCacheDir { get; set; }
        string LocalDodPassword { get; set; }
        string LocalDodServer { get; set; }
        string LocalDodServerPort { get; set; }
        string LocalDodSiteNumber { get; set; }
        string LocalDodUsername { get; set; }
        string NetworkFileShare { get; set; }
        string NetworkFileSharePassword { get; set; }
        string NetworkFileShareUsername { get; set; }
        string PreviousProductVersionProp { get; set; }
        string ProductVersionProp { get; set; }
        string SiteAbbreviation { get; set; }
        string SiteName { get; set; }
        string SiteNumber { get; set; }
        string SiteServiceUri { get; set; }
        void ToXml();
        string VistaServerName { get; set; }
        string VistaServerPort { get; set; }
        VixCacheType VixCacheOption { get; set; }
        int VixCacheSize { get; set; }
        //string VixCertificateInstallZipFilespec { get; set; }
        VixDeploymentType VixDeploymentOption { get; }
        bool AreBothNodesInstalled();
        bool AreBothNodesUpdated();
        string GetOtherNode();
        //bool IsPatch90orPatch101Installed { get; set; }
        string ApacheTomcatPassword { get; set; }
        VixRoleType VixRole { get; set; }
        bool IsPatch { get; set; }
        string VdigAccessor { get; set; }
        string VdigVerifier { get; set; }
        string DicomImageGatewayServer { get; set; }
        string DicomImageGatewayPort { get; set; }
        bool HasDicomConfiguration();
        //string DivisionNumber { get; set; }
        bool DicomListenerEnabled { get; set; }
        bool ArchiveEnabled { get; set; }
        bool IconGenerationEnabled { get; set; }
        string SitesFile { get; set; }
        string BhieUserName { get; set; }
        string BhiePassword { get; set; }
        string BhieProtocol { get; set; }
        string HaimsUserName { get; set; }
        string HaimsPassword { get; set; }
        string HaimsProtocol { get; set; }
        string NcatUserName { get; set; }
        string NcatPassword { get; set; }
        string NcatProtocol { get; set; }
        bool HasXcaConfiguration();
        int XcaConnectorPort { get; set; }
        int HttpConnectorPort { get; set; }
        string Station200UserName { get; set; }
        string VixServerNameProp { get; }
        bool UseOpenSslForXCAConnector { get; set; }
        string RenamedDeprecatedDcfRoot { get; set; }
        string NotificationEmailAddresses { get; set; }
        string RoiAccessor { get; set; }
        string RoiVerifier { get; set; }
        bool HasRoiConfiguration();
        bool IsLaurelBridgeRequired { get; }
    }
}
