using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Security;
using System.Security.Principal;
using System.Diagnostics;
using log4net;
using System.Xml;
using Microsoft.Win32;
using System.Threading;
using System.Runtime.InteropServices;

namespace gov.va.med.imaging.exchange.VixInstaller.business
{

    public static class BusinessFacade
    {
        private static readonly String PRODUCTION_BIA_USERNAME = "vavix660prod";
        private static readonly String PRODUCTION_BIA_PASSWORD = "rewRat7ekU";
        private static readonly String SMTP_SERVER_URI = "smtp.va.gov";
        private static readonly String VISTA_DOD_USERNAME = "bhieuser1";

        /// <summary>
        /// Retrieve a logger for this class.
        /// </summary>
        /// <returns>A logger as a ILog interface.</returns>
        private static ILog Logger()
        {
            return LogManager.GetLogger(typeof(BusinessFacade).Name);
        }

        private static InfoDelegate infoDelegate = null; // used to display a line of text to any WizardPage that has registered
        public static InfoDelegate InfoDelegate
        {
            get { return BusinessFacade.infoDelegate; }
            set { BusinessFacade.infoDelegate = value; }
        }

        private static VixManifest manifest = null; // the installation manifest
        public static VixManifest Manifest
        {
            get { return BusinessFacade.manifest; }
            set { BusinessFacade.manifest = value; }
        }

        public static String GetSmtpServerUri() { return SMTP_SERVER_URI; }

        public static String GetVistaDodUsername() { return VISTA_DOD_USERNAME; }

        public static String GetProductionBiaUsername() { return PRODUCTION_BIA_USERNAME; }

        public static String GetProductionBiaPassword() { return PRODUCTION_BIA_PASSWORD; }

        public static String GetPayloadZipPath(String startupPath)
        {
            // this may get more complicated, so its worth encapsulating
            return Path.Combine(startupPath, @"VIX\" + "VixDistribution.zip");
        }
        
        public static String GetPayloadPath(String applicationVersion, String startupPath)
        {
            // this may get more complicated, so its worth encapsulating
            return Path.Combine(startupPath, @"VIX\" + applicationVersion);
        }

        /// <summary>
        /// Checks to see if the current user has the Administrator role.
        /// </summary>
        /// <returns>true if the current user is an administrator, false otherwise</returns>
        /// <exception cref="ArgumentNullException"></exception>
        public static bool IsLoggedInUserAnAdministrator()
        {
            bool isAdmin = false;
            try
            {
                WindowsIdentity wi = WindowsIdentity.GetCurrent(); // SecurityException may be thrown
                WindowsPrincipal principal = new WindowsPrincipal(wi); // ArgumentNullException may be thrown
                if (principal.IsInRole(WindowsBuiltInRole.Administrator))
                {
                    isAdmin = true;
                }
            }
            catch (SecurityException ex)
            {
                // user does not have permissions to check so they are probably not a administrator
                Logger().Error("Windows Identity could not be retrieved : " + Environment.NewLine + ex.InnerException.Message);
            }
            catch (ArgumentNullException ex)
            {
                // windows identity came back null
                Logger().Error("Windows Identity is null : " + Environment.NewLine + ex.InnerException.Message);
            }
            return isAdmin;
       }

        public static String GetLoggedInUserName()
        {
            String userName = "Current user";
            try
            {
                WindowsIdentity wi = WindowsIdentity.GetCurrent(); // SecurityException may be thrown
                WindowsPrincipal principal = new WindowsPrincipal(wi); // ArgumentNullException may be thrown
                userName = wi.Name;
            }
            catch (SecurityException ex)
            {
                // user does not have permissions to check so they are probably not a administrator
                Logger().Error("Windows Identity could not be retrieved : " + Environment.NewLine + ex.InnerException.Message);
            }
            catch (ArgumentNullException ex)
            {
                // windows identity came back null
                Logger().Error("Windows Identity is null : " + Environment.NewLine + ex.InnerException.Message);
            }
            return userName;
        }
        
        public static bool IsWindowsXP()
        {
            bool isXP = false;
            if (Environment.OSVersion.Platform == PlatformID.Win32NT)
            {
                if (Environment.OSVersion.Version.Major == 5 && Environment.OSVersion.Version.Minor == 1)
                {
                    isXP = true;
                }
            }
            return isXP;
        }

        public static bool IsWindowsServer2003()
        {
            bool is2003 = false;
            if (Environment.OSVersion.Platform == PlatformID.Win32NT)
            {
                if (Environment.OSVersion.Version.Major == 5 && Environment.OSVersion.Version.Minor == 2)
                {
                    is2003 = true;
                }
            }
            return is2003;
        }

        public static bool IsWindowsServer2008()
        {
            bool is2008 = false;
            if (Environment.OSVersion.Platform == PlatformID.Win32NT)
            {
                if (Environment.OSVersion.Version.Major == 6 && Environment.OSVersion.Version.Minor == 1)
                {
                    is2008 = true;
                }
            }
            return is2008;
        }

        public static bool IsWindowsServer2012()
        {
            bool is2012 = false;
            if (Environment.OSVersion.Platform == PlatformID.Win32NT)
            {
                if (Environment.OSVersion.Version.Major == 6 && Environment.OSVersion.Version.Minor == 2)
                {
                    is2012 = true;
                }
            }
            return is2012;
        }

        public static bool IsWindowsServer2012R2()
        {
            bool is2012R2 = false;
            if (Environment.OSVersion.Platform == PlatformID.Win32NT)
            {
                if (Environment.OSVersion.Version.Major == 6 && Environment.OSVersion.Version.Minor == 3)
                {
                    is2012R2 = true;
                }
            }
            return is2012R2;
        }

        public static bool IsWindows7()
        {
            bool is7 = false;
            if (Environment.OSVersion.Platform == PlatformID.Win32NT)
            {
                if (Environment.OSVersion.Version.Major == 6 && Environment.OSVersion.Version.Minor == 2)
                {
                    is7 = true;
                }
            }
            return is7;
        }


        public static bool IsVista()
        {
            bool isVista = false;
            if (Environment.OSVersion.Platform == PlatformID.Win32NT)
            {
                if (Environment.OSVersion.Version.Major == 6 && Environment.OSVersion.Version.Minor == 0)
                {
                    isVista = true;
                }
            }
            return isVista;
        }

        public static bool IsOperatingSystemApproved(IVixConfigurationParameters config, bool devMode)
        {
            String info = null;
            return IsOperatingSystemApproved(ref info, config, devMode);
        }

        public static bool IsOperatingSystemApproved(ref String info, IVixConfigurationParameters config, bool devMode)
        {
            info = "Current operating system is not approved for the VIX service.";
            bool isApproved = false;

            //TODO: need to drive this from the manifest deployment configuration
            if (BusinessFacade.IsWindowsServer2003())
            {
                info = "Current operating system is Windows 2003.";
                isApproved = true;
            }
            else if (BusinessFacade.IsWindowsServer2008())
            {
                info = "Current operating system is Windows 2008.";
                isApproved = true;
            }
            else if (BusinessFacade.IsWindowsServer2012())
            {
                info = "Current operating system is Windows 2012.";
                isApproved = true;
            }
            else if (BusinessFacade.IsWindowsServer2012R2())
            {
                info = "Current operating system is Windows 2012 R2.";
                isApproved = true;
            }
            else if ((config.VixRole == VixRoleType.MiniVix || config.VixRole == VixRoleType.DicomGateway) && BusinessFacade.IsWindowsXP())
            {
                info = "Current operating system is Windows XP.";
                isApproved = true;
            }
            else if (config.VixRole == VixRoleType.MiniVix && BusinessFacade.IsWindows7())
            {
                info = "Current operating system is Windows 7.";
                isApproved = true;
            }
            else if (devMode && BusinessFacade.IsWindowsXP())
            {
                info = "Current operating system is Windows XP. (Dev mode)";
                isApproved = true;
            }
            else if (devMode && BusinessFacade.IsWindows7())
            {
                info = "Current operating system is Windows 7. (Dev mode)";
                isApproved = true;
            }
            else if (devMode && BusinessFacade.IsVista())
            {
                info = "Current operating system is Windows Vista. (Dev mode)";
                isApproved = true;
            }

            return isApproved;
        }

        [DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        [return: MarshalAs(UnmanagedType.Bool)]
        static extern bool IsWow64Process(IntPtr hProcess, out bool wow64Process);

        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        static extern IntPtr GetModuleHandle(string moduleName);

        [DllImport("kernel32.dll")]
        static extern IntPtr GetCurrentProcess();

        [DllImport("kernel32", CharSet = CharSet.Auto, SetLastError = true)]
        static extern IntPtr GetProcAddress(IntPtr hModule,
            [MarshalAs(UnmanagedType.LPStr)]string procName);

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static bool Is64BitOperatingSystem()
        {
            if (IntPtr.Size == 8)  // 64-bit programs run only on Win64
            {
                return true;
            }
            else  // 32-bit programs run on both 32-bit and 64-bit Windows
            {
                // Detect whether the current process is a 32-bit process 
                // running on a 64-bit system.
                bool flag = false;
                if (DoesWin32MethodExist("kernel32.dll", "IsWow64Process"))
                {
                    if (IsWow64Process(GetCurrentProcess(), out flag))
                    {
                        if (flag)
                        {
                            return true;
                        }
                    }
                }
                return false;
            }
        }

        //public static bool Is64BitOperatingSystem(out bool isWow64)
        //{
        //    Logger().Info("Is64BitOperatingSystem:");
        //    isWow64 = false;
        //    if (IntPtr.Size == 8)  // 64-bit programs run only on Win64
        //    {
        //        Logger().Info("IntPtr.Size == 8");
        //        return true;
        //    }
        //    else  // 32-bit programs run on both 32-bit and 64-bit Windows
        //    {
        //        // Detect whether the current process is a 32-bit process 
        //        // running on a 64-bit system.
        //        bool flag = false;
        //        if (DoesWin32MethodExist("kernel32.dll", "IsWow64Process"))
        //        {
        //            Logger().Info("DoesWin32MethodExist = true");
        //            if (IsWow64Process(GetCurrentProcess(), out flag))
        //            {
        //                Logger().Info("IsWow64Process = true");
        //                if (flag)
        //                {
        //                    Logger().Info("isWow64 = true");
        //                    isWow64 = true;
        //                    return true;
        //                }
        //            }
        //        }
        //        return false;
        //    }
        //}
        
        /// <summary>
        /// The function determins whether a method exists in the export 
        /// table of a certain module.
        /// </summary>
        /// <param name="moduleName">The name of the module</param>
        /// <param name="methodName">The name of the method</param>
        /// <returns>
        /// The function returns true if the method specified by methodName 
        /// exists in the export table of the module specified by moduleName.
        /// </returns>
        static bool DoesWin32MethodExist(string moduleName, string methodName)
        {
            IntPtr moduleHandle = GetModuleHandle(moduleName);
            if (moduleHandle == IntPtr.Zero)
            {
                return false;
            }
            return (GetProcAddress(moduleHandle, methodName) != IntPtr.Zero);
        }


        /// <summary>
        /// Check to see if any flavor of Visual VC++ 2008 Redistributable is installed.
        /// </summary>
        /// <returns>true if the runtime is installed, false otherwise</returns>
        //WFP-Do some checking on this.
        public static bool IsVCPlusPlus2008RedistributableInstalled()
        {
            bool isInstalled = false;
            string basekey = null;
            RegistryView regView = RegistryView.Registry32;
            if (BusinessFacade.Is64BitOperatingSystem() && Manifest.Enable64BitInstallation == false)
            {
                basekey = @"SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\";
            }
            else // native installation - either x86 or x64
            {
                basekey = @"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
            }

            string[] subkeys = Registry.LocalMachine.OpenSubKey(basekey).GetSubKeyNames();
            
            foreach (string subkey in subkeys)
            {
                RegistryKey regKey = RegistryKey.OpenBaseKey(RegistryHive.LocalMachine, regView);
                RegistryKey key = regKey.OpenSubKey(basekey + @"\" + subkey);
                string displayname = key.GetValue("DisplayName") as string;
                if (displayname != null && displayname.Contains("Microsoft Visual C++ 2008 Redistributable"))
                {
                    isInstalled = true;
                }
            }

            return isInstalled;
        }


        /// <summary>
        /// Check to see if any flavor of Visual VC++ 2008 Redistributable is installed.
        /// </summary>
        /// <returns>true if the runtime is installed, false otherwise</returns>
        //WFP-Do some checking on this.
        public static bool IsVCPlusPlus2013RedistributableInstalled()
        {
            bool isInstalled = false;
            string basekey = null;
            RegistryView regView = RegistryView.Registry32;
            if (BusinessFacade.Is64BitOperatingSystem() && Manifest.Enable64BitInstallation == false)
            {
                basekey = @"SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\";
            }
            else // native installation - either x86 or x64
            {
                basekey = @"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
            }

            string[] subkeys = Registry.LocalMachine.OpenSubKey(basekey).GetSubKeyNames();
            Logger().Info("subkeys array: " + subkeys.Length);

            foreach (string subkey in subkeys)
            {
                if (subkey != null)
                {
                    //Logger().Info("basekey: " + basekey);
                    RegistryKey regKey = RegistryKey.OpenBaseKey(RegistryHive.LocalMachine, regView);
                    //Logger().Info("regKey: " + regKey.ToString());
                    RegistryKey key = regKey.OpenSubKey(basekey + subkey);
                    //Logger().Info("key: " + key.ToString());
                    if (key != null)
                    {
                        string displayname = key.GetValue("DisplayName") as string;
                        Logger().Info("displayname: " + displayname);
                        if (displayname != null && displayname.Contains("Microsoft Visual C++ 2013"))
                        {
                            isInstalled = true;
                        }
                    }
                }
            }
            return isInstalled;
        }


        /// <summary>
        /// Install the Visual Studio 2005 VC++ runtime bundled with the Laurel Bridge toolkit
        /// </summary>
        /// <returns></returns>
        public static bool InstallVCPlusPlusRedistributableForLaurelBridge(string installerDirectory)
        {
            //if (IsVCPlusPlus2005x86RedistributableInstalled() == false) // safety net
              if (LaurelBridgeFacade.CanRunDcfInfo() == false) // safety net
                {
                Process externalProcess = new System.Diagnostics.Process();
                try
                {
                    string installerFilespec = null;
                    if (manifest.Enable64BitInstallation)
                    {
                        if (BusinessFacade.Is64BitOperatingSystem())
                        {
                            installerFilespec = Path.Combine(installerDirectory, @"vcredist_x64.exe"); // DKB - this is VC++ 2008 for DCF 3.3.26c
                        }
                        else
                        {
                            installerFilespec = Path.Combine(installerDirectory, @"vcredist_x86.exe");
                        }
                    }
                    else
                    {
                        installerFilespec = Path.Combine(installerDirectory, @"vcredist_x86.exe");
                    }

                    externalProcess.StartInfo.FileName = installerFilespec;
                    externalProcess.StartInfo.Arguments = " /Q";
                    externalProcess.StartInfo.WorkingDirectory = installerDirectory;
                    externalProcess.StartInfo.UseShellExecute = false;
                    //externalProcess.StartInfo.RedirectStandardError = true;
                    //externalProcess.StartInfo.RedirectStandardOutput = true;
                    externalProcess.StartInfo.CreateNoWindow = true;
                    externalProcess.Start();
                    do
                    {
                        Thread.Sleep(500);
                        externalProcess.Refresh();
                    } while (!externalProcess.HasExited);
                }
                finally
                {
                    externalProcess.Close();
                    externalProcess = null;
                }
            }
            //return IsVCPlusPlus2005x86RedistributableInstalled();
              return LaurelBridgeFacade.CanRunDcfInfo();
        }

        /// <summary>
        /// Install the Visual Studio 2008 VC++ runtime required by the CVIX OpenSSL FIPS 140-2 compliant runtime
        /// </summary>
        /// <returns></returns>
        public static bool InstallVCPlusPlus2008Redistributable()
        {
            if (IsVCPlusPlus2008RedistributableInstalled() == false) // safety net
            {
                Process externalProcess = new System.Diagnostics.Process();
                try
                {
                    string workingDir = Path.Combine(manifest.PayloadPath, @"server");
                    string installerFilespec = null;
                    if (manifest.Enable64BitInstallation)
                    {
                        if (BusinessFacade.Is64BitOperatingSystem())
                        {
                            installerFilespec = Path.Combine(workingDir, @"vcredist_x64.exe");
                        }
                        else
                        {
                            installerFilespec = Path.Combine(workingDir, @"vcredist_x86.exe");
                        }
                    }
                    else
                    {
                        installerFilespec = Path.Combine(workingDir, @"vcredist_x86.exe");
                    }

                    externalProcess.StartInfo.FileName = installerFilespec;
                    externalProcess.StartInfo.Arguments = " /Q";
                    externalProcess.StartInfo.WorkingDirectory = workingDir;
                    externalProcess.StartInfo.UseShellExecute = false;
                    //externalProcess.StartInfo.RedirectStandardError = true;
                    //externalProcess.StartInfo.RedirectStandardOutput = true;
                    externalProcess.StartInfo.CreateNoWindow = true;
                    externalProcess.Start();
                    do
                    {
                        Thread.Sleep(500);
                        externalProcess.Refresh();
                    } while (!externalProcess.HasExited);
                }
                finally
                {
                    externalProcess.Close();
                    externalProcess = null;
                }
            }
            return IsVCPlusPlus2008RedistributableInstalled();
        }


        /// <summary>
        /// Install the Visual Studio 2013 VC++ runtime
        /// </summary>
        /// <returns></returns>
        public static bool InstallVCPlusPlus2013Redistributable()
        {
            if (IsVCPlusPlus2013RedistributableInstalled() == true)
            {
                return true;
            }
            Process externalProcess = new System.Diagnostics.Process();
            try
            {
                string workingDir = Path.Combine(manifest.PayloadPath, @"common\Misc");
                string installerFilespec = null;
                if (manifest.Enable64BitInstallation)
                {
                    if (BusinessFacade.Is64BitOperatingSystem())
                    {
                        installerFilespec = Path.Combine(workingDir, @"vcredist_x64.exe");
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
                externalProcess.StartInfo.FileName = installerFilespec;
                externalProcess.StartInfo.Arguments = " /Q";
                externalProcess.StartInfo.WorkingDirectory = workingDir;
                externalProcess.StartInfo.UseShellExecute = false;
                //externalProcess.StartInfo.RedirectStandardError = true;
                //externalProcess.StartInfo.RedirectStandardOutput = true;
                externalProcess.StartInfo.CreateNoWindow = true;
                externalProcess.Start();
                do
                {
                    Thread.Sleep(500);
                    externalProcess.Refresh();
                } while (!externalProcess.HasExited);
            }
            finally
            {
                externalProcess.Close();
                externalProcess = null;
            }
            return IsVCPlusPlus2013RedistributableInstalled();
        }



        /// <summary>
        /// A helper method to wrap the infoDelegate member, which if non null provide a way to report status to the 
        /// user interface.
        /// </summary>
        /// <param name="infoMessage">message to display in the user interface.</param>
        /// <returns>the message string passed in the infoMessage parameter to support chaining.</returns>
        private static String Info(String infoMessage)
        {
            if (infoDelegate != null)
            {
                infoDelegate(infoMessage);
            }
            Logger().Info(infoMessage); // any info provided to the presentation layer will be logged.
            return infoMessage;
        }

        public static bool DoesEnvironmentVariableExist(string envVariableName)
        {
            // append to the path
            String envVariable = Environment.GetEnvironmentVariable("envVariableName", EnvironmentVariableTarget.Machine);
            return envVariable == null ? false : true;
        }

    }
}
