using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using gov.va.med.imaging.exchange.VixInstaller.business;
using System.ServiceProcess;
using System.Threading;

namespace gov.va.med.imaging.exchange.VixInstaller.ui
{
    public partial class UndeployVixPage : gov.va.med.imaging.exchange.VixInstaller.ui.InteriorWizardPage
    {
        public UndeployVixPage()
        {
            InitializeComponent();
        }

        public UndeployVixPage(IWizardForm wizForm, int pageIndex)
            : base(wizForm, pageIndex)
        {
            InitializeComponent();
        }

        protected override String Info(String infoMessage)
        {
            this.textBoxInfo.AppendText(infoMessage + Environment.NewLine);
            return infoMessage;
        }

        #region IWizardPage Members
        public override void Initialize()
        {
            this.InitializeBusinessFacadeDelegates();
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();

            if (config.VixRole == VixRoleType.DicomGateway)
            {
                this.InteriorPageHeader = @"Update HDIG components from " + config.PreviousProductVersionProp + " to " +
                    config.ProductVersionProp;
            }
            else
            {
                this.InteriorPageHeader = @"Update VIX components from " + config.PreviousProductVersionProp + " to " +
                    config.ProductVersionProp;
            }

            this.buttonUninstallViXWebApps.Text = "Uninstall version " + config.PreviousProductVersionProp;

            this.SetPageSubHeader();

            // set wizard form button state
            if (this.IsComplete())
            {
                this.WizardForm.EnableNextButton(true);
                this.buttonUninstallViXWebApps.Enabled = false;
            }
            else
            {
                this.WizardForm.EnableNextButton(false);
            }
            this.WizardForm.EnableBackButton(true);
            this.WizardForm.EnableCancelButton(true);
        }

        public override bool IsComplete()
        {
            bool isComplete = false;

            if (VixFacade.IsVixInstalled() == false)
            {
                if (TomcatFacade.IsDeprecatedTomcatVersionInstalled() == false) // require that any deprecated version of Tomcat be uninstalled before continuing
                {
                    // do a java check if we are not in developer mode
                    if (this.WizardForm.IsDeveloperMode())
                    {
                        isComplete = true;
                    }
                    else
                    {
                        isComplete = !JavaFacade.IsDeprecatedJreInstalled();
                    }
                }
            }
            return isComplete;
        }

        #endregion

        #region private methods
        private void SetPageSubHeader()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            if (this.IsComplete())
            {
                this.InteriorPageSubHeader = "Uninstall complete. Click Next to continue.";
            }
            else
            {
                if (config.VixRole == VixRoleType.DicomGateway)
                {
                    this.InteriorPageSubHeader = "Click Uninstall button to remove existing HDIG web applications.";
                }
                else
                {
                    this.InteriorPageSubHeader = "Click Uninstall button to remove existing VIX web applications.";
                }
            }
        }
        #endregion

        #region events
        private void buttonUninstallViXWebApps_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                this.buttonUninstallViXWebApps.Enabled = false;
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();

                if (TomcatFacade.IsTomcatInstalled())
                {
                    ServiceControllerStatus status = ServiceUtilities.GetLocalServiceStatus(TomcatFacade.TomcatServiceName);
                    this.Info("The ApacheTomcat service is " + status.ToString("g"));
                    if (status != ServiceControllerStatus.Stopped)
                    {
                        if (ClusterFacade.IsServerClusterNode())
                        {
                            MessageBox.Show("Use the Cluster Administrator to take the VIX service resource offline and then try again.",
                                "Clustered VIX - Additional action required", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                            return;
                        }
                        else
                        {
                            this.Info("Stopping ApacheTomcat service.");
                            // attempt to stop the service
                            ServiceUtilities.StopLocalService(TomcatFacade.TomcatServiceName);
                            do
                            {
                                Application.DoEvents();
                                Thread.Sleep(500);
                                status = ServiceUtilities.GetLocalServiceStatus(TomcatFacade.TomcatServiceName);
                            }
                            while (status == System.ServiceProcess.ServiceControllerStatus.StopPending);
                            status = ServiceUtilities.GetLocalServiceStatus(TomcatFacade.TomcatServiceName);
                            this.Info("The ApacheTomcat service is " + status.ToString("g"));
                            if (status != ServiceControllerStatus.Stopped)
                            {
                                MessageBox.Show("Please use the Service Manager to stop the ApacheTomcat service then try again.",
                                    "Cannot stop the ApacheTomcat service", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                                return;
                            }
                           //now stop the ZFViewer services.
                           bool viewerStopStatus = ZFViewerFacade.StopZFViewerServices();
                           if (viewerStopStatus == false)
                           {
                               MessageBox.Show("Please use the Service Manager to stop the VIX Viewer and/or Render service then try again.",
                                   "Cannot stop the VIX Viewer and/or Render service", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                               return;

                           }
                           //now uninstall the ZFViewer services
                           bool viewerUninstallStatus = ZFViewerFacade.DeleteZFViewerWindowsServices();
                           if (viewerUninstallStatus == false)
                           {
                               MessageBox.Show("Failed to uninstall the VIX Viewer and/or Render service(s).",
                                   "Cannot uninstall the VIX Viewer and/or Render service(s)", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                               return;

                           }
                        }
                    }

                    VixFacade.UndeployVixWebApplications(config);

                    if (TomcatFacade.IsDeprecatedTomcatVersionInstalled() == true)
                    {
                        this.Info("Uninstalling Tomcat version " + TomcatFacade.DeprecatedTomcatVersion);
                        TomcatFacade.UninstallDeprecatedTomcat();
                        if (TomcatFacade.IsDeprecatedTomcatServiceInstalled())
                        {
                            this.Info("Tomcat service is still installed - reboot required.");
                            DialogResult result = MessageBox.Show("A reboot is required to uininstall the Tomcat6 windows service. After rebooting please re-run the VIX Installation Service Wizard.",
                                "Reboot required.", MessageBoxButtons.OK);
                            return;
                        }
                    }
                    else
                    {
                        // TODO: someday it may be necessary to detect if a x86 version of the active tomcat version is installed on an x64 OS and force an uninstall
                    }
                }

                if (JavaFacade.IsJavaInstalled(false) == false)
                {
                    if (JavaFacade.IsDeprecatedJreInstalled())
                    {
                        this.Info("Uninstalling JRE version " + JavaFacade.DeprecatedJavaVersion);
                        JavaFacade.UninstallDeprecatedJre();
                    }
                    else
                    {
                        // TODO: someday it may be necessary to detect if a x86 version of the active JRE version is installed on an x64 OS and force an uninstall
                    }
                }

                // uninstall Laurel Bridge if necessary
                if (LaurelBridgeFacade.IsDeprecatedLaurelBridgeInstalled())
                {
                    this.Info("Removing existing Laurel Bridge DCF toolkit version " + LaurelBridgeFacade.GetDeprecatedLaurelBridgeVersion());
                    LaurelBridgeFacade.RemoveLaurelBridgeInstallation(config);
                    LaurelBridgeFacade.SaveRenamedDeprecatedDcfRoot(config.RenamedDeprecatedDcfRoot); // save only the deprecated root to disk so we dont lose it
                }

                this.Info("Press Next to continue.");
            }
            finally
            {
                Cursor.Current = Cursors.Default;
                this.buttonUninstallViXWebApps.Enabled = true;
                this.Initialize();
            }
        }
        #endregion

     }
}

