using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using gov.va.med.imaging.exchange.VixInstaller.business;

namespace gov.va.med.imaging.exchange.VixInstaller.ui
{
    public partial class ServiceAccountDialog : Form
    {
        public ServiceAccountDialog()
        {
            InitializeComponent();
        }

        public String Password
        {
            get { return this.textBoxPassword.Text; }
        }

        //public String Username
        //{
        //    get { return this.textBoxUsername.Text; }
        //}

        private void ServiceAccountDialog_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.ClearErrors();
            
            if (this.DialogResult == DialogResult.OK)
            {
                if (this.textBoxPassword.Text.Length == 0)
                {
                    this.errorProvider.SetError(this.textBoxPassword, "You must provide a password.");
                    this.labelErrorInfo.Visible = true;
                    e.Cancel = true;
                }
                else if (this.textBoxPassword.Text.Length < 8)
                {
                    this.errorProvider.SetError(this.textBoxPassword, "Password must be at least 8 characters in length.");
                    this.labelErrorInfo.Visible = true;
                    e.Cancel = true;
                }
                else if (!Regex.IsMatch(this.textBoxPassword.Text, "[A-Z]")) // check for the capital char
                {
                    this.errorProvider.SetError(this.textBoxPassword, "Password must contain at least one capital letter.");
                    this.labelErrorInfo.Visible = true;
                    e.Cancel = true;
                }
                else if (!Regex.IsMatch(this.textBoxPassword.Text, "[0-9]")) // check for the number char
                {
                    this.errorProvider.SetError(this.textBoxPassword, "Password must contain at least one number character.");
                    this.labelErrorInfo.Visible = true;
                    e.Cancel = true;
                }

                if (this.textBoxConfirmPassword.Text.Length == 0)
                {
                    this.errorProvider.SetError(this.textBoxConfirmPassword, "You must provide a password.");
                    this.labelErrorInfo.Visible = true;
                    e.Cancel = true;
                }
                else if (this.textBoxPassword.Text != this.textBoxConfirmPassword.Text)
                {
                    this.errorProvider.SetError(this.textBoxConfirmPassword, "Passwords do not match. Please re-type.");
                    this.labelErrorInfo.Visible = true;
                    e.Cancel = true;
                }
            }
        }

        /// <summary>
        /// Clear out any previous passwords. This is necessary to avoid the error provider displaying
        /// any previous errors in the event of the user canceling then re-displaying the form.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ServiceAccountDialog_Load(object sender, EventArgs e)
        {
            this.textBoxUsername.Text = TomcatFacade.ServiceAccountUsername;
            this.textBoxPassword.Text = "";
            this.textBoxConfirmPassword.Text = "";
            this.ClearErrors();
        }

        private void ClearErrors()
        {
            this.labelErrorInfo.Visible = false;
            this.errorProvider.Clear();
        }
    }

}