using System;
using System.Collections.Generic;
using System.Windows.Forms;
using log4net;
using gov.va.med.imaging.exchange.VixInstaller.business;
using System.IO;
using System.Configuration;


namespace gov.va.med.imaging.exchange.VixInstaller.ui
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            if (File.Exists("vix-install-log.txt"))
            {
                File.Delete("vix-install-log.txt");
            }
            log4net.Config.XmlConfigurator.Configure(new System.IO.FileInfo("VixInstallerLog.xml"));

            if (args.Length == 1 && args[0] == "-testbed")
            {
                Application.Run(new Form1());
            }
            else
            {
                // unzip the VIX distribution payload if necessary
                VixManifest manifest = new VixManifest(Application.StartupPath);
                String payloadJar = Path.Combine(manifest.PayloadPath, @"server\jars");
                if (!Directory.Exists(payloadJar))
                {
                    String unzipPath = Path.Combine(Application.StartupPath, "VIX");
                    String vixZipFile = BusinessFacade.GetPayloadZipPath(Application.StartupPath);
                    try
                    {
                        Application.UseWaitCursor = true;
                        ZipUtilities.UnZip(vixZipFile, unzipPath);
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message, "VIX Installer Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    finally
                    {
                        Application.UseWaitCursor = false;
                    }
                }

                // reality check against the ViX distribution zip file being built incorrectly
                if (!Directory.Exists(payloadJar))
                {
                    String message = "The VIX distribution files contained in the VixDistribution.zip file cannot be installed by the VIX Installer version " +
                        Application.ProductVersion + ". Please contact technical support.";
                    MessageBox.Show(message, "VIX Distribution/Installer Mismatch", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    // display the wizard form to the user
                    Application.Run(new WizardForm());
                    if (Directory.Exists(manifest.PayloadPath))
                    {
                        Directory.Delete(manifest.PayloadPath, true); // uninstall will clean up the zip file
                    }
                }
            }
        }
    }
}