using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using System.Threading;
using gov.va.med.imaging.exchange.VixInstaller.business;
using System.Configuration;

namespace gov.va.med.imaging.exchange.VixInstaller.ui
{
    public partial class InstallVixPage : gov.va.med.imaging.exchange.VixInstaller.ui.InteriorWizardPage
    {
        private BiaCredentialsDialog biaCredentialsDialog = new BiaCredentialsDialog();

        public InstallVixPage()
        {
            InitializeComponent();
        }

        public InstallVixPage(IWizardForm wizForm, int pageIndex)
            : base(wizForm, pageIndex)
        {
            InitializeComponent();
        }

        protected override String Info(String infoMessage)
        {
            this.textBoxInfo.AppendText(infoMessage + Environment.NewLine);
            return infoMessage;
        }

        #region IWizardPage Members
        public override void Initialize()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            this.InitializeBusinessFacadeDelegates();
            if (config.VixRole == VixRoleType.DicomGateway)
            {
                this.InteriorPageHeader = "Install the HDIG.";
            }
            else
            {
                this.InteriorPageHeader = "Install the VIX.";
            }

            //if (VixFacade.Manifest.MajorPatchNumber == 34)
            if (config.VixRole == VixRoleType.DicomGateway)
            {
                this.WizardForm.GetVixConfigurationParameters().BiaPassword = "N/A for DICOM deployment1";
                this.WizardForm.GetVixConfigurationParameters().BiaUsername = "N/A for DICOM deployment2";
            }
            else
            {
                this.WizardForm.GetVixConfigurationParameters().VdigAccessor = "N/A for non DICOM deployment1";
                this.WizardForm.GetVixConfigurationParameters().VdigVerifier = "N/A for non DICOM deployment2";
            }

            if (this.WizardForm.IsDeveloperMode())
            {
                //if (VixFacade.Manifest.MajorPatchNumber == 34)
                if (VixFacade.Manifest.ContainsVixRole(VixRoleType.DicomGateway) || VixFacade.Manifest.ContainsVixRole(VixRoleType.RelayVix))
                {
                    this.buttonConfigBiaCredentials.Visible = false;
                }
                else
                {
                    this.buttonConfigBiaCredentials.Visible = true;
                }
            }
            else
            {
                this.buttonConfigBiaCredentials.Visible = false;
            }

            // set wizard form button state
            if (this.IsComplete())
            {
                if (config.VixRole == VixRoleType.DicomGateway)
                {
                    this.InteriorPageSubHeader = "The HDIG has been installed. Click Finish to exit the wizard.";
                }
                else
                {
                    this.InteriorPageSubHeader = "The VIX has been installed. Click Finish to exit the wizard.";
                }
                this.WizardForm.EnableFinishButton(true);
                this.WizardForm.EnableBackButton(false);
                this.WizardForm.EnableCancelButton(false);
                this.buttonInstall.Enabled = false;
                this.buttonConfigBiaCredentials.Enabled = false;
            }
            else
            {
                this.InteriorPageSubHeader = "Click Install to begin.";
                this.WizardForm.EnableNextButton(false);
                this.WizardForm.EnableBackButton(true);
                this.WizardForm.EnableCancelButton(true);
                this.buttonInstall.Enabled = true;
                this.buttonConfigBiaCredentials.Enabled = true;
            }
        }

        public override bool IsComplete()
        {
            return VixFacade.IsVixInstalled();
        }

        #endregion

        #region events
        private void buttonInstall_Click(object sender, EventArgs e)
        {
            //if (VixFacade.Manifest.MajorPatchNumber == 83)
            //{
            //    IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            //    // HACK ALERT - for P83T31 VIX prevent federation interface response for VistARad if P90/P101 is not installed
            //    DialogResult result = MessageBox.Show("If a test version of one of the following VistARad patches is installed at your site, click \"Yes\"\nto enable VistARad support.\n\nMAG*3.0*90\nMAG*3.0*101\n\nIf you click \"No\" and install a VistARad test patch after this point, you will need to reinstall the VIX service.",
            //        "Enable VistARad support?", MessageBoxButtons.YesNo);
            //    if (result == DialogResult.Yes)
            //    {
            //        config.IsPatch90orPatch101Installed = true;
            //    }
            //    else
            //    {
            //        config.IsPatch90orPatch101Installed = false;
            //    }
            //}
            this.InstallVix();
        }

        private void buttonConfigBiaCredentials_Click(object sender, EventArgs e)
        {
            if (this.biaCredentialsDialog.ShowDialog() == DialogResult.OK) // ask for password associated with the admin account
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.BiaUsername = this.biaCredentialsDialog.Username;
                config.BiaPassword = this.biaCredentialsDialog.Password;
            }
        }

        #endregion

        #region private methods
        private void InstallVix()
        {
            this.textBoxInfo.Clear();
            this.WizardForm.EnableBackButton(false);
            this.WizardForm.EnableCancelButton(false);
            this.buttonInstall.Enabled = false;
            this.buttonConfigBiaCredentials.Enabled = false;
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                //String payloadPath = VixFacade.Manifest.PayloadPath;
                //bool isDeveloperMode = WizardForm.IsDeveloperMode();
                VixFacade.InstallVix(config); //, isDeveloperMode);
            }
            finally
            {
                Cursor.Current = Cursors.Default;
                this.Initialize();
                if (ClusterFacade.IsServerClusterNode())
                {
                    this.ProvideAdditionalClusterInstructions();
                }
            }
        }

        private void ProvideAdditionalClusterInstructions()
        {
            string message = null;
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            if (config.IsNewVixInstallation())
            {
                if (config.AreBothNodesInstalled() == true)
                {
                    message = "You have installed the VIX service on " + Environment.MachineName + ". The VIX service has been installed on both " + Environment.MachineName + " and " + config.GetOtherNode() + ". To complete the installation use Cluster Administrator to add the VIX service as a resource to the Imaging Resources group and then bring the VIX service resource online.";
                }
                else
                {
                    message = "You have installed the VIX service on  " + Environment.MachineName + ". Your next step is to use Cluster Administrator to transfer the Imaging Resources group to the second cluster server and repeat the VIX installation.";
                }
            }
            else
            {
                if (config.AreBothNodesUpdated() == true)
                {
                    message = "You have updated the VIX service on " + Environment.MachineName + ". The VIX service has been updated on both " + Environment.MachineName + " and " + config.GetOtherNode() + ". To complete the update use Cluster Administrator to bring the VIX service resource online.";
                }
                else
                {
                    message = "You have updated the VIX service on " + Environment.MachineName + ". Your next step is to use Cluster Administrator to transfer the Imaging Resources group to " + config.GetOtherNode() + " and repeat the VIX installation.";
                }
            }
            Debug.Assert(message != null);
            MessageBox.Show(message, "Clustered VIX - Additional action required", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            Logger().Info("Additional Setup Instructions:");
            Logger().Info(message);
        }

        #endregion

    }
}

