using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using gov.va.med.imaging.exchange.VixInstaller.business;

namespace gov.va.med.imaging.exchange.VixInstaller.ui
{
    public partial class ConfigureXcaPage : gov.va.med.imaging.exchange.VixInstaller.ui.InteriorWizardPage
    {
        private static bool firstTime = true;
        private static bool enableEvents = true;
        private XcaInfoDialog xcaInfoDialog = new XcaInfoDialog();

        public ConfigureXcaPage()
        {
            InitializeComponent();
        }

        public ConfigureXcaPage(IWizardForm wizForm, int pageIndex)
            : base(wizForm, pageIndex)
        {
            InitializeComponent();
        }

        #region IWizardPage Members
        public override void Initialize()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            if (firstTime)
            {
                enableEvents = false;
                this.InitializeBusinessFacadeDelegates();
                this.InteriorPageHeader = @"Configure XCA connections.";
                this.LoadConfigurationInfo();
                if (config.BhieProtocol == null || config.HaimsProtocol == null || config.NcatProtocol == null)
                {
                    this.buttonValidate.Enabled = true;
                }
                this.WizardForm.EnableBackButton(true);
                this.WizardForm.EnableCancelButton(true);
                this.textBoxBhieUsername.Focus();
                firstTime = false;
                enableEvents = true;
            }

            this.SetPageSubHeader();

            if (VixFacade.IsXcaCertificateInstalled())
            {
                this.labelXcaCertificate.Text = "The XCA keystore and truststore are installed.";
                this.buttonXcaCertificate.Enabled = false;
            }
            else
            {
                this.labelXcaCertificate.Text = "The XCA keystore and truststore are not installed. Select ZIP file.";
                this.buttonXcaCertificate.Enabled = true;
            }

            if (BusinessFacade.IsVCPlusPlus2008RedistributableInstalled())
            {
                this.labelVCPlusPlus2008Runtime.Text = "The Visual Studio 2008 VC++ runtime is installed.";
                this.buttonVCPlusPlus2008Runtime.Enabled = false;
            }
            else
            {
                this.labelVCPlusPlus2008Runtime.Text = "The Visual Studio 2008 VC++ runtime is not installed.";
                this.buttonVCPlusPlus2008Runtime.Enabled = true;
            }

            // set wizard form button state
            if (this.IsComplete())
            {
                this.WizardForm.EnableNextButton(true);
            }
            else
            {
                this.WizardForm.EnableNextButton(false);
            }
        }

        public override bool IsComplete()
        {
            bool isComplete = false;
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();

            if (this.buttonValidate.Enabled == false)
            {
                if (config.HasXcaConfiguration() && VixFacade.IsXcaCertificateInstalled() && BusinessFacade.IsVCPlusPlus2008RedistributableInstalled())
                {
                    isComplete = true;
                }
            }

            return isComplete;
        }

        #endregion

        #region events

        private void textBoxBhieUsername_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.BhieUserName = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxBhiePassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.BhiePassword = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxBhieConfirmPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.BhiePassword = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void comboBoxBhieProtocol_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.BhieProtocol = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxHaimsUsername_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.HaimsUserName = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxHaimsPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.HaimsPassword = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxHaimsConfirmPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.HaimsPassword = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }

        }

        private void comboBoxHaimsProtocol_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.HaimsProtocol = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxNcatUsername_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.NcatUserName = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxNcatPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.NcatPassword = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxNcatConfirmPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.NcatPassword = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void comboBoxNcatProtocol_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.NcatProtocol = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxXcaConnectorPort_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxHttpConnectorPort_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxStation200UserName_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }

        }

        private void buttonXcaCertificate_Click(object sender, EventArgs e)
        {
            if (VixFacade.IsXcaCertificateInstalled() == false)
            {
                DialogResult result = this.xcaInfoDialog.ShowDialog();

                if (result == DialogResult.OK) // Cancel will skip this
                {
                    this.buttonXcaCertificate.Enabled = false;
                    Application.DoEvents();

                    string certStoreDir = VixFacade.GetVixCertificateStoreDir();
                    if (!Directory.Exists(certStoreDir))
                    {
                        Directory.CreateDirectory(certStoreDir);
                    }
                    ZipUtilities.UnZip(this.xcaInfoDialog.CertificatePath, certStoreDir);
                }
                this.Initialize();
            }
        }

        private void buttonVCPlusPlus2008Runtime_Click(object sender, EventArgs e)
        {
            if (BusinessFacade.IsVCPlusPlus2008RedistributableInstalled() == false)
            {
                this.buttonVCPlusPlus2008Runtime.Enabled = false;
                Application.DoEvents();
                if (BusinessFacade.InstallVCPlusPlus2008Redistributable() == false)
                {
                    errorProvider.SetError(buttonVCPlusPlus2008Runtime, "Could not install VS 2008 C++ Runtime.");
                }
                this.Initialize();
            }
        }

        private void buttonValidate_Click(object sender, EventArgs e)
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            bool validated = true;
            this.errorProvider.Clear();
            this.labelErrorInfo.Visible = false;

            validated &= this.ValidateCredentials();
            validated &= this.ValidateConnectorPort(this.textBoxXcaConnectorPort);
            validated &= this.ValidateConnectorPort(this.textBoxHttpConnectorPort);

            if (this.textBoxStation200UserName.Text.Trim().Length == 0)
            {
                this.errorProvider.SetError(this.textBoxStation200UserName, "You must provide a Station 200 username");
                this.labelErrorInfo.Visible = true;
                validated = false;
            }

            if (validated) // check that different ports have been specified
            {
                if (this.textBoxXcaConnectorPort.Text == this.textBoxHttpConnectorPort.Text)
                {
                    this.errorProvider.SetError(this.textBoxXcaConnectorPort, "XCA and HTTP ports must be different");
                    this.errorProvider.SetError(this.textBoxHttpConnectorPort, "XCA and HTTP ports must be different");
                    this.labelErrorInfo.Visible = true;
                    validated = false;
                }
            }

            if (VixFacade.IsXcaCertificateInstalled() == false)
            {
                this.errorProvider.SetError(this.buttonXcaCertificate, "You must select an XCA certificate and truststore");
                this.labelErrorInfo.Visible = true;
                validated = false;
            }

            if (validated)
            {
                this.SaveConfigurationInfo();
                this.buttonValidate.Enabled = false;
                this.Initialize();
            }
            else
            {
                this.labelErrorInfo.Visible = true;
            }
        }

        #endregion

        #region private methods

        private void LoadConfigurationInfo()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            enableEvents = false;
            this.textBoxBhieUsername.Text = (config.BhieUserName == null) ? "" : config.BhieUserName;
            this.textBoxBhiePassword.Text = (config.BhiePassword == null) ? "" : config.BhiePassword;
            this.textBoxBhieConfirmPassword.Text = (config.BhiePassword == null) ? "" : config.BhiePassword;
            comboBoxBhieProtocol.SelectedItem = config.BhieProtocol == null ? "xca" : config.BhieProtocol.ToLower(); // 11/29/10 - force previously saved protocol to lowercase

            this.textBoxHaimsUsername.Text = (config.HaimsUserName == null) ? "" : config.HaimsUserName;
            this.textBoxHaimsPassword.Text = (config.HaimsPassword == null) ? "" : config.HaimsPassword;
            this.textBoxHaimsConfirmPassword.Text = (config.HaimsPassword == null) ? "" : config.HaimsPassword;
            comboBoxHaimsProtocol.SelectedItem = config.HaimsProtocol == null ? "xca" : config.HaimsProtocol.ToLower(); // 11/29/10 - force previously saved protocol to lowercase

            this.textBoxNcatUsername.Text = (config.NcatUserName == null) ? "" : config.NcatUserName;
            this.textBoxNcatPassword.Text = (config.NcatPassword == null) ? "" : config.NcatPassword;
            this.textBoxNcatConfirmPassword.Text = (config.NcatPassword == null) ? "" : config.NcatPassword;
            comboBoxNcatProtocol.SelectedItem = config.NcatProtocol == null ? "xca" : config.NcatProtocol.ToLower(); // 11/29/10 - force previously saved protocol to lowercase

            this.textBoxStation200UserName.Text = (config.Station200UserName == null) ? "" : config.Station200UserName;

            this.textBoxXcaConnectorPort.Text = config.XcaConnectorPort.ToString();
            this.textBoxHttpConnectorPort.Text = config.HttpConnectorPort.ToString();
            
            enableEvents = true;
        }

        private void SaveConfigurationInfo()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            config.BhieUserName = (this.textBoxBhieUsername.Text == "") ? null : this.textBoxBhieUsername.Text.Trim();
            config.BhiePassword = (this.textBoxBhiePassword.Text == "") ? null : this.textBoxBhiePassword.Text;
            config.BhieProtocol = this.comboBoxBhieProtocol.SelectedItem.ToString();

            config.HaimsUserName = (this.textBoxHaimsUsername.Text == "") ? null : this.textBoxHaimsUsername.Text.Trim();
            config.HaimsPassword = (this.textBoxHaimsPassword.Text == "") ? null : this.textBoxHaimsPassword.Text;
            config.HaimsProtocol = this.comboBoxHaimsProtocol.SelectedItem.ToString();

            config.NcatUserName = (this.textBoxNcatUsername.Text == "") ? null : this.textBoxNcatUsername.Text.Trim();
            config.NcatPassword = (this.textBoxNcatPassword.Text == "") ? null : this.textBoxNcatPassword.Text;
            config.NcatProtocol = this.comboBoxNcatProtocol.SelectedItem.ToString();

            config.Station200UserName = (this.textBoxStation200UserName.Text == "") ? null : this.textBoxStation200UserName.Text.Trim();

            config.XcaConnectorPort = Int32.Parse(this.textBoxXcaConnectorPort.Text);
            config.HttpConnectorPort = Int32.Parse(this.textBoxHttpConnectorPort.Text);
        }
        
        private void SetPageSubHeader()
        {
            if (this.IsComplete())
            {
                this.InteriorPageSubHeader = "The CVIX connections have specified. Click Next to continue.";
            }
            else
            {
                this.InteriorPageSubHeader = "Enter the requried CVIX connection information.";
            }
        }

        private bool ValidateConnectorPort(TextBox box)
        {
            bool validated = true;
            int port;

            if (Int32.TryParse(box.Text, out port))
            {
                if (port <= 0)
                {
                    this.errorProvider.SetError(box, "Port must be > 0");
                    this.labelErrorInfo.Visible = true;
                    validated = false;
                }
            }
            else
            {
                this.errorProvider.SetError(box, "Port must be numeric");
                this.labelErrorInfo.Visible = true;
                validated = false;
            }

            return validated;
        }
        
        private bool ValidateCredentials()
        {
            bool validated = true;

            if (this.textBoxBhieUsername.Text.Trim().Length > 0)
            {
                if (this.textBoxBhiePassword.Text.Trim().Length == 0)
                {
                    this.errorProvider.SetError(this.textBoxBhiePassword, "You must provide a verify code.");
                    this.labelErrorInfo.Visible = true;
                    validated = false;
                }

                if (this.textBoxBhieConfirmPassword.Text.Trim().Length == 0)
                {
                    this.errorProvider.SetError(this.textBoxBhieConfirmPassword, "You must provide a verify code.");
                    validated = false;
                }
                else if (this.textBoxBhiePassword.Text != this.textBoxBhieConfirmPassword.Text)
                {
                    this.errorProvider.SetError(this.textBoxBhieConfirmPassword, "Verify codes do not match. Please re-type.");
                    this.labelErrorInfo.Visible = true;
                    validated = false;
                }
            }

            return validated;
        }

        #endregion

    }
}

