using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using gov.va.med.imaging.exchange.VixInstaller.business;
using System.Diagnostics;

namespace gov.va.med.imaging.exchange.VixInstaller.ui
{
    public partial class ConfigureVixWormholePage : gov.va.med.imaging.exchange.VixInstaller.ui.InteriorWizardPage
    {
        private bool firstTime = true;
        private bool enableEvents = true;

        public ConfigureVixWormholePage()
        {
            InitializeComponent();
        }

        public ConfigureVixWormholePage(IWizardForm wizForm, int pageIndex)
            : base(wizForm, pageIndex)
        {
            InitializeComponent();
        }

        #region IWizardPage Members
        public override void Initialize()
        {
            if (firstTime == true)
            {
                this.InitializeBusinessFacadeDelegates();
                this.InteriorPageHeader = @"Configure local DoD connection for images";
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                if (config.HasLocalDodConfiguration())
                {
                    this.checkBoxWormhole.Checked = true; // fires the CheckedChanged event to enable controls
                    this.LoadConfigurationInfo();
                }
                this.WizardForm.EnableBackButton(true);
                this.WizardForm.EnableCancelButton(true);
                firstTime = false;
            }

            errorProvider.Clear();
            this.SetPageSubHeader();

            if (this.checkBoxWormhole.Checked == true)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                this.buttonValidate.Enabled = config.HasLocalDodConfiguration() ? false : true; // saved config means nothing to validate until changes made
            }
            else
            {
                this.buttonValidate.Enabled = false;
            }

            // set wizard form button state
            if (this.IsComplete())
            {
                this.WizardForm.EnableNextButton(true);
            }
            else
            {
                this.WizardForm.EnableNextButton(false);
            }
        }

        public override bool IsComplete()
        {
            bool isComplete = false;
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();

            if (this.checkBoxWormhole.Checked == false)
            {
                isComplete = true;
            }
            else if (config.HasLocalDodConfiguration())
            {
                isComplete = true;
            }
            
            return isComplete;
        }

        #endregion

        #region private methods
        private void SetPageSubHeader()
        {
            if (this.IsComplete())
            {
                if (this.checkBoxWormhole.Checked == true)
                {
                    this.InteriorPageSubHeader = "Connection is configured. Click the Next button to continue.";
                }
                else
                {
                    this.InteriorPageSubHeader = "No connection specified. Click the Next button to continue.";
                }
            }
            else
            {
                this.InteriorPageSubHeader = "Please provide DoD connection information and click the Validate button.";
            }
        }

        private void EnableControls(bool enable)
        {
            this.textBoxDodServer.Enabled = enable;
            this.textBoxDodServer.BackColor = (enable == true) ? SystemColors.Window : SystemColors.Control;
            this.textBoxDodServerPort.Enabled = enable;
            this.textBoxDodServerPort.BackColor = (enable == true) ? SystemColors.Window : SystemColors.Control;
            this.textBoxDodSiteNumber.Enabled = enable;
            this.textBoxDodSiteNumber.BackColor = (enable == true) ? SystemColors.Window : SystemColors.Control;
            this.textBoxUsername.Enabled = enable;
            this.textBoxUsername.BackColor = (enable == true) ? SystemColors.Window : SystemColors.Control;
            this.textBoxPassword.Enabled = enable;
            this.textBoxPassword.BackColor = (enable == true) ? SystemColors.Window : SystemColors.Control;
            this.textBoxConfirmPassword.Enabled = enable;
            this.textBoxConfirmPassword.BackColor = (enable == true) ? SystemColors.Window : SystemColors.Control;
        }

        private void ResetConfigurationInfo()
        {
            enableEvents = false;
            this.textBoxDodServer.Text = "";
            this.textBoxDodServerPort.Text = "";
            this.textBoxDodSiteNumber.Text = "";
            this.textBoxUsername.Text = "";
            this.textBoxPassword.Text = "";
            this.textBoxConfirmPassword.Text = "";
            this.SaveConfigurationInfo();
            enableEvents = true;
        }

        private void LoadConfigurationInfo()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            enableEvents = false;
            this.textBoxDodServer.Text = (config.LocalDodServer == null) ? "" : config.LocalDodServer;
            this.textBoxDodServerPort.Text = (config.LocalDodServerPort == null) ? "" : config.LocalDodServerPort;
            this.textBoxDodSiteNumber.Text = (config.LocalDodSiteNumber == null) ? "" : config.LocalDodSiteNumber;
            this.textBoxUsername.Text = (config.LocalDodUsername == null) ? "" : config.LocalDodUsername;
            this.textBoxPassword.Text = (config.LocalDodPassword == null) ? "" : config.LocalDodPassword;
            this.textBoxConfirmPassword.Text = this.textBoxPassword.Text;
            enableEvents = true;
        }

        private void SaveConfigurationInfo()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            config.LocalDodServer = (this.textBoxDodServer.Text.Trim() == "") ? null : this.textBoxDodServer.Text.Trim();
            config.LocalDodServerPort = (this.textBoxDodServerPort.Text.Trim() == "") ? null : this.textBoxDodServerPort.Text.Trim();
            config.LocalDodSiteNumber = (this.textBoxDodSiteNumber.Text.Trim() == "") ? null : this.textBoxDodSiteNumber.Text.Trim();
            config.LocalDodUsername = (this.textBoxUsername.Text.Trim() == "") ? null : this.textBoxUsername.Text.Trim();
            config.LocalDodPassword = (this.textBoxPassword.Text.Trim() == "") ? null : this.textBoxPassword.Text.Trim();
        }

        #endregion
        
        #region validation
        private bool ValidateServerAddress()
        {
            bool validated = true;

            if (this.textBoxDodServer.Text.Trim() == "")
            {
                this.errorProvider.SetError(this.textBoxDodServer, "DoD server IP address must be specified");
                validated = false;
            }
            //else
            //{
            //    String[] parts = this.textBoxDodServer.Text.Split('.');
            //    if (parts.Length != 4)
            //    {
            //        this.errorProvider.SetError(this.textBoxDodServer, "The IP address is malformed");
            //        validated = false;
            //    }
            //    else
            //    {
            //        int result;
            //        foreach (String part in parts)
            //        {
            //            if (Int32.TryParse(part, out result) == false)
            //            {
            //                this.errorProvider.SetError(this.textBoxDodServer, "The IP address is malformed");
            //                validated = false;
            //                break;
            //            }
            //        }
            //    }
            //}

            return validated;
        }

        private bool ValidateServerPort()
        {
            bool validated = true;

            if (this.textBoxDodServerPort.Text.Trim() == "")
            {
                this.errorProvider.SetError(this.textBoxDodServerPort, "DoD server port must be specified");
                validated = false;
            }
            else
            {
                int result;
                if (Int32.TryParse(this.textBoxDodServerPort.Text.Trim(), out result) == false)
                {
                    this.errorProvider.SetError(this.textBoxDodServerPort, "The server port is malformed");
                    validated = false;
                }
            }

            return validated;
        }

        private bool ValidateSiteNumber()
        {
            bool validated = true;

            if (this.textBoxDodSiteNumber.Text.Trim() == "")
            {
                this.errorProvider.SetError(this.textBoxDodSiteNumber, "DoD site number must be specified");
                validated = false;
            }
            // not sure we can assume all numeric

            return validated;
        }

        private bool ValidateUsername()
        {
            bool validated = true;

            if (this.textBoxUsername.Text.Trim() == "")
            {
                this.errorProvider.SetError(this.textBoxUsername, "Username must be specified");
                validated = false;
            }
            // not sure we can assume all numeric

            return validated;
        }

        private bool ValidatePassword()
        {
            bool validated = true;

            if (this.textBoxPassword.Text.Trim() == "")
            {
                this.errorProvider.SetError(this.textBoxPassword, "Password must be specified");
                validated = false;
            }

            if (this.textBoxConfirmPassword.Text.Trim() == "")
            {
                this.errorProvider.SetError(this.textBoxConfirmPassword, "Password must be specified");
                validated = false;
            }

            if (validated == true)
            {
                if (this.textBoxPassword.Text.Trim() != this.textBoxConfirmPassword.Text.Trim())
                {
                    this.errorProvider.SetError(this.textBoxConfirmPassword, "Passwords do not match. Please re-type");
                    validated = false;
                }
            }

            return validated;
        }
        #endregion

        #region events

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonValidate_Click(object sender, EventArgs e)
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            bool validated = true;
            Debug.Assert(config.HasLocalDodConfiguration() == false);
            this.errorProvider.Clear();

            validated &= this.ValidateServerAddress();
            validated &= this.ValidateServerPort();
            validated &= this.ValidateSiteNumber();
            validated &= this.ValidateUsername();
            validated &= this.ValidatePassword();

            if (validated)
            {
                this.SaveConfigurationInfo();
                this.buttonValidate.Enabled = false;
                this.Logger().Info("Wormhole configured to DoD site  " + config.LocalDodSiteNumber);
                this.Initialize();
            }
        }
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void checkBoxWormhole_CheckedChanged(object sender, EventArgs e)
        {
            if (this.checkBoxWormhole.Checked == true)
            {
                this.EnableControls(true);
            }
            else
            {
                this.EnableControls(false);
                this.ResetConfigurationInfo();
            }
            this.Initialize();
        }

        // Modifying a textbox nulls out the corresponding configuration field until validation saves the full configuration
        // information. This gives us a way to detemine if we have completed data entry.

        private void textBoxDodServer_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                if (config.LocalDodServer != null)
                {
                    config.LocalDodServer = null; // validation will re-initialize
                    this.buttonValidate.Enabled = true;
                    this.Initialize();
                }
            }
        }

        private void textBoxDodServerPort_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                if (config.LocalDodServerPort != null)
                {
                    config.LocalDodServerPort = null; // validation will re-initialize
                    this.buttonValidate.Enabled = true;
                    this.Initialize();
                }
            }
        }

        private void textBoxDodSiteNumber_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                if (config.LocalDodSiteNumber != null)
                {
                    config.LocalDodSiteNumber = null; // validation will re-initialize
                    this.buttonValidate.Enabled = true;
                    this.Initialize();
                }
            }
        }

        private void textBoxUsername_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                if (config.LocalDodUsername != null)
                {
                    config.LocalDodUsername = null; // validation will re-initialize
                    this.buttonValidate.Enabled = true;
                    this.Initialize();
                }
            }
        }

        private void textBoxPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                if (config.LocalDodPassword != null)
                {
                    config.LocalDodPassword = null; // validation will re-initialize
                    this.buttonValidate.Enabled = true;
                    this.Initialize();
                }
            }
        }

        private void textBoxConfirmPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                if (config.LocalDodPassword != null)
                {
                    config.LocalDodPassword = null; // validation will re-initialize
                    this.buttonValidate.Enabled = true;
                    this.Initialize();
                }
            }
        }

        #endregion

    }
}

