using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using gov.va.med.imaging.exchange.VixInstaller.business;

namespace gov.va.med.imaging.exchange.VixInstaller.ui
{
    public partial class ConfigureRoiPage : gov.va.med.imaging.exchange.VixInstaller.ui.InteriorWizardPage
    {
        private static bool firstTime = true;
        private static bool enableEvents = true;

        public ConfigureRoiPage()
        {
            InitializeComponent();
        }

        public ConfigureRoiPage(IWizardForm wizForm, int pageIndex)
            : base(wizForm, pageIndex)
        {
            InitializeComponent();
        }

        #region IWizardPage Members
        public override void Initialize()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            if (firstTime)
            {
                enableEvents = false;
                this.InitializeBusinessFacadeDelegates();
                this.InteriorPageHeader = @"Specify the Release of Information (ROI) configuration.";
                this.LoadConfigurationInfo();
                this.WizardForm.EnableBackButton(true);
                this.WizardForm.EnableCancelButton(true);
                firstTime = false;
                enableEvents = true;
            }

            //this.ConfigurePageForDeveloperMode();

            this.SetPageSubHeader();

            // set wizard form button state
            if (this.IsComplete())
            {
                this.WizardForm.EnableNextButton(true);
            }
            else
            {
                this.WizardForm.EnableNextButton(false);
            }
        }

        public override bool IsComplete()
        {
            bool isComplete = false;
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();

            if (config.HasRoiConfiguration())
            {
                isComplete = true;
            }

            return isComplete;
        }

        #endregion

        #region events

        private void textBoxUsername_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.RoiAccessor = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.RoiVerifier = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxConfirmPassword_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.RoiVerifier = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void textBoxNotificationEmailAddresses_TextChanged(object sender, EventArgs e)
        {
            if (enableEvents)
            {
                IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
                config.RoiVerifier = null; // validation will re-initialize
                this.buttonValidate.Enabled = true;
                this.Initialize();
                this.WizardForm.EnableNextButton(false);
            }
        }

        private void buttonValidate_Click(object sender, EventArgs e)
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            bool validated = true;
            this.errorProvider.Clear();
            this.labelErrorInfo.Visible = false;

            validated &= this.ValidateCredentials();
            validated &= this.ValidateNotificationEmailAddresses();

            if (validated)
            {
                this.SaveConfigurationInfo();
                this.buttonValidate.Enabled = false;
                this.Initialize();
            }
            else
            {
                this.labelErrorInfo.Visible = true;
            }
        }

        #endregion

        #region private methods

        private void LoadConfigurationInfo()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            enableEvents = false;
            this.textBoxUsername.Text = (config.RoiAccessor == null) ? "" : config.RoiAccessor;
            this.textBoxPassword.Text = (config.RoiAccessor == null) ? "" : config.RoiVerifier;
            this.textBoxConfirmPassword.Text = (config.RoiVerifier == null) ? "" : config.RoiVerifier;
            this.textBoxNotificationEmailAddresses.Text = config.NotificationEmailAddresses;
            enableEvents = true;
        }

        private void SaveConfigurationInfo()
        {
            IVixConfigurationParameters config = this.WizardForm.GetVixConfigurationParameters();
            config.RoiAccessor = (this.textBoxUsername.Text == "") ? null : this.textBoxUsername.Text;
            config.RoiVerifier = (this.textBoxPassword.Text == "") ? null : this.textBoxPassword.Text;
            config.NotificationEmailAddresses = this.textBoxNotificationEmailAddresses.Text;
        }
        
        private void SetPageSubHeader()
        {
            if (this.IsComplete())
            {
                this.InteriorPageSubHeader = "The ROI configuration has been specified. Click Next to continue.";
            }
            else
            {
                this.InteriorPageSubHeader = "Enter the required ROI configuration information.";
            }
        }

        private bool ValidateNotificationEmailAddresses()
        {
            bool validated = true;

            if (this.textBoxNotificationEmailAddresses.Text.Trim() == "")
            {
                this.errorProvider.SetError(this.textBoxNotificationEmailAddresses, "One or more comma seperated notification email addresses must be specified.");
                validated = false;
            }
            return validated;
        }

        private bool ValidateCredentials()
        {
            bool validated = true;

            if (this.textBoxUsername.Text.Trim().Length == 0)
            {
                this.errorProvider.SetError(this.textBoxUsername, "You must provide a access code.");
                this.labelErrorInfo.Visible = true;
                validated = false;
            }

            if (this.textBoxPassword.Text.Trim().Length == 0)
            {
                this.errorProvider.SetError(this.textBoxPassword, "You must provide a verify code.");
                this.labelErrorInfo.Visible = true;
                validated = false;
            }

            if (this.textBoxConfirmPassword.Text.Trim().Length == 0)
            {
                this.errorProvider.SetError(this.textBoxConfirmPassword, "You must provide a verify code.");
                validated = false;
            }
            else if (this.textBoxPassword.Text != this.textBoxConfirmPassword.Text)
            {
                this.errorProvider.SetError(this.textBoxConfirmPassword, "Verify codes do not match. Please re-type.");
                this.labelErrorInfo.Visible = true;
                validated = false;
            }

            return validated;
        }

        #endregion


    }
}

