/**
 * 
 * Property of ISI Group, LLC
 * Date Created: Jun 4, 2015
 * Developer: Julian Werfel
 */
package gov.va.med.imaging.study.web.commands;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.study.web.ViewerStudyFacadeRouter;
import gov.va.med.imaging.study.web.rest.translator.ViewerStudyWebTranslator;
import gov.va.med.imaging.study.web.rest.types.ViewerStudyFilterType;
import gov.va.med.imaging.study.web.rest.types.ViewerStudyStudiesType;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Julian
 *
 */
public class GetPatientStudiesCommand
extends AbstractViewerStudyWebCommand<List<Study>, ViewerStudyStudiesType>
{
	private final String siteId;
	private final String patientIcn;
	private final ViewerStudyFilterType filterType;
	/**
	 * @param methodName
	 * @param siteId
	 * @param patientIdentifier
	 */
	public GetPatientStudiesCommand(String siteId,
		String patientIcn, ViewerStudyFilterType filterType)
	{
		super("getPatientStudies");
		this.siteId = siteId;
		this.patientIcn = patientIcn;
		this.filterType = filterType;
	}	
	
	/**
	 * @return the filterType
	 */
	public ViewerStudyFilterType getFilterType()
	{
		return filterType;
	}

	/**
	 * @return the siteId
	 */
	public String getSiteId()
	{
		return siteId;
	}

	/**
	 * @return the patientIdentifier
	 */
	public String getPatientIcn()
	{
		return patientIcn;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#executeRouterCommand()
	 */
	@Override
	protected List<Study> executeRouterCommand()
		throws MethodException, ConnectionException
	{
		ViewerStudyFacadeRouter router = getRouter();
		try
		{
			StudyFilter filter = ViewerStudyWebTranslator.translate(getFilterType());
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(getSiteId());
			//return router.getShallowStudyListBySiteNumber(routingToken, patientIcn, filter);
			PatientIdentifier patientIdentifier = PatientIdentifier.icnPatientIdentifier(patientIcn);
			ArtifactResults artifactResults = router.getStudyOnlyByStudyURN(routingToken, patientIdentifier, filter, true, true);
			List<Study> result = new ArrayList<Study>(artifactResults.getStudySetResult().getArtifacts());
			return result;

		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new MethodException(rtfX);
		}
	}
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getMethodParameterValuesString()
	 */
	@Override
	protected String getMethodParameterValuesString()
	{
		return "for patient [" + getPatientIcn() + "] to site [" + getSiteId() + "]";
	}
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#translateRouterResult(java.lang.Object)
	 */
	@Override
	protected ViewerStudyStudiesType translateRouterResult(List<Study> routerResult)
		throws TranslationException, MethodException
	{
		return ViewerStudyWebTranslator.translateStudies(routerResult);
	}
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getResultClass()
	 */
	@Override
	protected Class<ViewerStudyStudiesType> getResultClass()
	{
		return ViewerStudyStudiesType.class;
	}
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getTransactionContextFields()
	 */
	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.patientId, getPatientIcn() == null ? "" : getPatientIcn());
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.queryFilter, transactionContextNaValue);
	
		return transactionContextFields;
	}
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getEntriesReturned(java.lang.Object)
	 */
	@Override
	public Integer getEntriesReturned(ViewerStudyStudiesType translatedResult)
	{
		return translatedResult == null ? 0 : translatedResult.getStudy().length;
	}
	
	

}
