package gov.va.med.imaging.mix.translator;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.json.*;

import gov.va.med.imaging.StringUtil;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.mix.DODImageURN;
import gov.va.med.imaging.mix.webservices.rest.exceptions.MIXImagingStudyException;
import gov.va.med.imaging.mix.webservices.rest.types.v1.ErrorResultType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.InstanceType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.ModalitiesType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.ReportStudyListResponseType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.SeriesType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.SeriesTypeComponentInstances;
import gov.va.med.imaging.mix.webservices.rest.types.v1.StudyType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.StudyTypeComponentSeries;


public class MixJSONConverter
{
	private static Logger logger = Logger.getLogger(MixJSONConverter.class);	

	public static ReportStudyListResponseType ConvertDiagnosticReportToJava(String jsonData)
	{
		ReportStudyListResponseType rslr = null;
		
		try {
		     JSONObject obj = new JSONObject(jsonData);
		     JSONArray dRs = obj.getJSONArray(""); // Is "" ok for [{..}] ???
		     if ((dRs==null) || (dRs.length()==0)) {
		    	 return rslr;
		     }
		     List<StudyType> studies = new ArrayList<StudyType>();
		     List<ErrorResultType> errors = new ArrayList<ErrorResultType>();

		     for (int i = 0; i < dRs.length(); i++) {
		    	 JSONObject curDR = dRs.getJSONObject(i);
			     String status = curDR.getString("status"); // ?check for "final"
			     String discipline = curDR.getString("category"); // ?check for "final"
			     String subject = curDR.getJSONObject("subject").getString("reference");
			     String patId = subject.replace("Patient/", ""); // take off FHIR Patient resource reference tag, keep ICN 
			     String report = curDR.getJSONObject("text").getString("div");

			     JSONArray shallowStudies = curDR.getJSONArray("shallowStudy");
			     for (int j = 0; j < shallowStudies.length(); j++) {
			    	 StudyType study = new StudyType();

			    	 JSONObject curSStudy = shallowStudies.getJSONObject(j);
				     String procDate = curSStudy.getString("started"); // *** "yyyy-MM-ddTHH:MI:SS+HHH:MI"
				     String proc = curSStudy.getString("procedure"); // description
				     int numSeries = curSStudy.getInt("numberOfSeries");
				     int numInstances = curSStudy.getInt("numberOfInstances");
				     String modList = curSStudy.getString("modalityList"); // *** might need array treatment getting "code" from each member
				     String[] modalities = StringUtil.split(modList, StringUtil.COMMA);
				     ModalitiesType mt = new ModalitiesType(modalities);
				     String uid = curSStudy.getString("uid");
				     study.setProcedureDate(procDate);
				     study.setProcedureDescription(proc);
				     study.setSeriesCount(numSeries);
				     study.setImageCount(numInstances);
				     study.setModalities(mt);
				     study.setDicomUid(uid);
				     study.setReportContent(report);
				     study.setPatientId(patId);
				     if (discipline!=null && !discipline.isEmpty())
				    	 study.setSpecialtyDescription(discipline);
				    	 
				     studies.add(study);
			     }
		     }
		     rslr = new ReportStudyListResponseType();
		     for (int i = 0; i < studies.size(); i++) {
			     rslr.setStudies(i, studies.get(i));
		     }
		}
		catch (JSONException je) {
			logger.info("FHIR DiagnosticReport response JSON data object error: " + je.getMessage());
			return null;
		}
		// ***
		return rslr;
	}
	
	public static StudyType ConvertImagingStudyToJava(String jsonData)
	throws MIXImagingStudyException {
		StudyType st = null;
		try {
		     JSONObject iS = new JSONObject(jsonData);
		     if (iS.length()==0) {
		    	 return st;
		     }
		     st = new StudyType();
		     List<SeriesType> series = new ArrayList<SeriesType>();
		     DODImageURN dodURN = new DODImageURN();
		     
		     String started = iS.getString("started"); // *** "yyyy-MM-ddTHH:MI:SS+HHH:MI"
		     String patRef = iS.getJSONObject("patient").getString("reference");
		     String patId = patRef.replace("Patient/", ""); // take off FHIR Patient resource reference prefix 
		     String stdUid = iS.getString("uid");
		     String proc = iS.getString("procedure");
		     String desc = iS.getString("description");
		     int numSeries = iS.getInt("numberOfSeries");
		     int numInstances = iS.getInt("numberOfInstances");
		     String modList = iS.getString("modalityList"); // *** might need array treatment getting "code" from each member
		     String[] modalities = StringUtil.split(modList, StringUtil.COMMA);
		     ModalitiesType mt = new ModalitiesType(modalities);
		     st.setProcedureDate(started);
		     st.setPatientId(patId);
		     st.setDicomUid(stdUid);
		     st.setModalities(mt);
		     st.setSeriesCount(numSeries);
		     st.setImageCount(numInstances);
		     st.setProcedureDescription(proc);
		     st.setDescription(desc);
		     //st.setReportContent(report); // cannot be filled here!!! -  make sure it's not lost from diagnostic report query!

		     JSONArray serieses = iS.getJSONArray("series");
		     for (int i = 0; i < serieses.length(); i++) {
		    	 SeriesType serT = new SeriesType();
			     List<InstanceType> instances = new ArrayList<InstanceType>();
			     
		    	 JSONObject curSeries = serieses.getJSONObject(i);
				 int serNum = curSeries.getInt("started"); // *** "yyyy-MM-ddTHH:MI:SS+HHH:MI"
			     String modality = curSeries.getString("modality");
			     String serUid = curSeries.getString("uid");
			     String serDesc = curSeries.getString("description");
			     int numSerInstances = curSeries.getInt("numberOfInstances");
			     serT.setDicomSeriesNumber(serNum);
			     serT.setModality(modality);
			     serT.setDicomUid(serUid);
			     serT.setDescription(serDesc);
			     serT.setImageCount(numSerInstances);
			     
			     JSONArray insts = iS.getJSONArray("instance");
			     for (int j = 0; j < insts.length(); j++) {
			    	 InstanceType insT = new InstanceType();
			    	 JSONObject curIns = insts.getJSONObject(j);
					 int insNum = curIns.getInt("number");
			    	 String sopUid = curIns.getString("uid");
			    	 String sopClass = curIns.getString("sopClass"); // where to put it? - not in InstanceType, not conveyed anyhow...
			    	 insT.setDicomInstanceNumber(insNum);
				     insT.setDicomUid(sopUid);
				     
				     try {
				    	 insT.setImageUrn((String)dodURN.create(stdUid, serUid, sopUid).toString());
				     } catch(URNFormatException ufe) {
				    	 throw new MIXImagingStudyException("Error creating DOD imageURN: " + ufe.getMessage());
				     }
				    	 
				     instances.add(insT);
			     }
			     
			     // hook instances!
			     InstanceType[] seriesInstances = instances.toArray(new InstanceType[instances.size()]);
			     SeriesTypeComponentInstances instancesWrapper = new SeriesTypeComponentInstances();
			     instancesWrapper.setInstance(seriesInstances);
			     serT.setComponentInstances(instancesWrapper);

			     series.add(serT);
		     }
		     
		     // hook series!
		     SeriesType[] studySeries = series.toArray(new SeriesType[series.size()]);
		     StudyTypeComponentSeries instancesWrapper = new StudyTypeComponentSeries();
		     instancesWrapper.setSeries(studySeries);
		     st.setComponentSeries(instancesWrapper);
		}
		catch (JSONException je) {
			logger.info("FHIR ImagingStudy response JSON data object error: " + je.getMessage());
			return null;
		}
		// *** log if inconsistencies found!
		return st;
	}
}

