/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Nov 14, 2016
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vacotittoc
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.mix.proxy.v1;

// import java.rmi.RemoteException;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.Site;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.business.StudySetResult;
import gov.va.med.imaging.exchange.enums.StudyLoadLevel;
import gov.va.med.imaging.mix.webservices.rest.exceptions.MIXMetadataException;
import gov.va.med.imaging.mix.webservices.rest.types.v1.FilterType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.ReportStudyListResponseType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.RequestorType;
import gov.va.med.imaging.mix.webservices.rest.types.v1.RequestorTypePurposeOfUse;
import gov.va.med.imaging.mix.webservices.rest.v1.ImageMetadata;
import gov.va.med.imaging.mix.webservices.translator.v1.MixTranslatorV1;






// import gov.va.med.imaging.proxy.ImageXChangeHttpCommonsSender;
import com.sun.jersey.client.apache.ApacheHttpClient;

import gov.va.med.imaging.proxy.services.ProxyServiceType;
import gov.va.med.imaging.proxy.services.ProxyServices;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.mix.configuration.MIXConfiguration;

/**
 * @author vacotittoc
 *
 */
public class ImageMixStudyProxyV1
extends ImageMixProxyV1
{
	private final Site site;	
//	private final static String defaultRemoteRepository = "*"; // get from all remote sites
	
	public ImageMixStudyProxyV1(ProxyServices proxyServices, Site site, MIXConfiguration mixConfiguration)
	{
		super(proxyServices, mixConfiguration);
		this.site = site;
	}
	
	public StudySetResult getPatientStudies(String patientIcn,
			StudyFilter filter, StudyLoadLevel studyLoadLevel)
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		logger.info("Transaction [" + transactionContext.getTransactionId() + "] initiated ");
		ImageMetadata imageMetadata = getImageMetadataService();
		
		// if the metadata connection parameters are not null and the metadata connection parameters
		// specifies a user ID then set the UID/PWD parameters as XML parameters, which should
		// end up as a BASIC auth parameter in the HTTP header
		setMetadataCredentials(imageMetadata);
		
		// JMW 8/13/08 - set the connection socket timeout to 30 seconds (default of 600 seconds)
		// CPT 11/14/16 - take care of this inside MIX call
		// ((org.apache.axis.client.Stub)imageMetadata).setTimeout(mixConfiguration.getMetadataTimeout());
		RequestorType rt = 
				new RequestorType(
						transactionContext.getFullName(), 
						transactionContext.getSsn(), 
						transactionContext.getSiteNumber(), 
						transactionContext.getSiteName(), 
				RequestorTypePurposeOfUse.value1);
		
		FilterType ft = MixTranslatorV1.translate(filter);
		
		String datasource = defaultDatasource;
		ReportStudyListResponseType reportStudyListResponse = null;
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		try
		{
			// make MIX client calls to build MIX Pass 1 (metadata) response
			//       1. to get the Patient's study shallow list with reports using filters, (JSON-> DiagnosticReport)
			//       2. then to collect study graphs for each study (JSON-> ImagingSudy-s of DiagnosticReport)

			Thread.currentThread().setContextClassLoader(ApacheHttpClient.class.getClassLoader());
			reportStudyListResponse = imageMetadata.getPatientReportStudyList(   
					datasource, 
					rt, 
					ft, 
					patientIcn, 
					true, // fullTree with study list
					transactionContext.getTransactionId(),
					defaultDatasource
			);
		}
		catch(MIXMetadataException rX)
		{
			logger.error("Error in MIX getPatientStudies", rX);
			throw new ConnectionException(rX);
		}
		finally
		{
			Thread.currentThread().setContextClassLoader(loader);
		}
		logger.info("Transaction [" + transactionContext.getTransactionId() + "] returned " + 
				(reportStudyListResponse == null ? "null" : "not null") + " study list response");
		StudySetResult result = MixTranslatorV1.translate(reportStudyListResponse, site, filter,
				mixConfiguration.getEmptyStudyModalities());
		logger.info("StudySetResult translated: " + (result == null ? "null" : result.toString(true)));
		transactionContext.addDebugInformation("StudySetResult: " + (result == null ? "null" : result.toString(true)));
		return result;
	}
}
