/**
 * 
 * Property of ISI Group, LLC
 * Date Created: Sep 24, 2014
 * Developer: Julian Werfel
 */
package gov.va.med.imaging.tomcat.vistarealm.encryption;

import gov.va.med.imaging.encryption.exceptions.AesEncryptionException;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

/**
 * @author Julian
 *
 */
public class TokenFilter
implements Filter
{
	protected final static Logger logger = Logger.getLogger(TokenFilter.class);
	
	/* (non-Javadoc)
	 * @see javax.servlet.Filter#destroy()
	 */
	@Override
	public void destroy()
	{
		
	}

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
		FilterChain chain)
	throws IOException, ServletException
	{
		if(request instanceof HttpServletRequest)
		{
			HttpServletRequest servletRequest = (HttpServletRequest)request;
			String securityToken = servletRequest.getParameter("securityToken");
			logger.debug("Security Token from URL: "+ securityToken);
			if(securityToken != null && securityToken.length() > 0)
			{
				try
				{
					logger.info("Authenticating user with provided security token");
					logger.debug("Request String [" + servletRequest.getRequestURL().toString() + "]");
					logger.debug("Query String [" + servletRequest.getQueryString() + "]");
					logger.debug("Security Token [" + securityToken + "]");
					
					if(securityToken.endsWith("x/x"))
					{
						securityToken = securityToken.substring(0, securityToken.length() - 4);
						logger.debug("Security token included bad trailing characters, token now [" + securityToken + "]");
					}
					
					EncryptionToken.decryptUserCredentials(securityToken);
				} 
				catch(TokenExpiredException teX)
				{
					logger.error("Security token has expired");
					throw new ServletException("Security Token has expired");
				}
				catch (AesEncryptionException aesX)
				{
					logger.error("Error decrypting security token, " + aesX.getMessage());
					throw new ServletException("Cannot decrypt security token");
				}
			}
		}
		chain.doFilter(request, response);
	}

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	@Override
	public void init(FilterConfig filterConfig)
	throws ServletException
	{

	}
}
