/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created:
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.wado;

import gov.va.med.URNFactory;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.enums.ImageFormat;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import gov.va.med.URN;
import gov.va.med.URNFactory;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.enums.ImageFormat;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.wado.AbstractBaseImageServlet;
import gov.va.med.imaging.wado.AbstractBaseImageServlet.ImageServletException;

public class DiagnosticServlet 
extends AbstractBaseImageServlet
{
	private static final long serialVersionUID = 1L;
	private static List<ImageFormat> diagnosticResponseType;
	private Logger logger = Logger.getLogger(this.getClass());
	
	static
	{
		 diagnosticResponseType = new ArrayList<ImageFormat>();
		 diagnosticResponseType.add(ImageFormat.DICOMJPEG2000);
	}

	@Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) 
	throws ServletException, IOException
    {
		String pathInfo = req.getPathInfo();
		if(pathInfo == null || pathInfo.isEmpty())
		{
			resp.sendError(HttpServletResponse.SC_BAD_REQUEST, "The image URN was not specified in the URL and must be.");
		}
		else
		{
			String imageIdentifier = pathInfo.charAt(0) == '/' ? pathInfo.substring(1) : pathInfo;
			logger.info("Getting diagnostic image '" + pathInfo + "'.");
			try
	        {
		        ImageURN imageUrn = URNFactory.create(imageIdentifier, ImageURN.class);
		    	long bytesTransferred = streamImageInstanceByUrn(
		    			imageUrn, ImageQuality.DIAGNOSTIC,
		    			diagnosticResponseType, 
		    			resp.getOutputStream(),
		    			new MetadataNotification(resp));
	        } 
			catch (URNFormatException e)
	        {
				logger.info(e.getMessage());
				resp.sendError(HttpServletResponse.SC_BAD_REQUEST, "'" + imageIdentifier + "' is not a valid image identifier (ImageURN).");
	        } 
			catch (ImageServletException isX)
	        {
				logger.error(isX.getMessage(), isX);
				resp.sendError(isX.getResponseCode(), isX.getMessage());
	        }
			catch(Exception ex)
			{
				logger.error(ex.getMessage(), ex);
				resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, ex.getMessage());
			}
		}		
    }

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.wado.AbstractBaseImageServlet#getUserSiteNumber()
	 */
	@Override
	public String getUserSiteNumber() 
	{
		TransactionContext context = TransactionContextFactory.get();
		return context.getLoggerSiteNumber();
	}
}
