/**
 * 
 * Property of ISI Group, LLC
 * Date Created: Jul 8, 2014
 * Developer: Julian Werfel
 */
package gov.va.med.imaging.hydra.web;

import gov.va.med.imaging.exchange.enums.ImageFormat;
import gov.va.med.imaging.exchange.enums.ImageQuality;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Julian
 *
 */
public class ThumbnailServlet
extends AbstractHydraImageServlet
{

	private static final long serialVersionUID = 2224568416028047862L;

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.hydra.web.AbstractHydraImageServlet#getAcceptableResponseContent()
	 */
	@Override
	protected List<ImageFormat> getAcceptableResponseContent(HttpServletRequest request)
	{
		List<ImageFormat> acceptableResponseContent = new ArrayList<ImageFormat>();
		acceptableResponseContent.add(ImageFormat.JPEG);
		return acceptableResponseContent;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.hydra.web.AbstractHydraImageServlet#getImageQuality()
	 */
	@Override
	protected ImageQuality getImageQuality(HttpServletRequest request)
	{
		return ImageQuality.THUMBNAIL;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.hydra.web.AbstractHydraImageServlet#getOperationName()
	 */
	@Override
	protected String getOperationName()
	{
		return "getThumbnail";
	}

}
