/**
 * 
  Property of ISI Group, LLC
  Date Created: May 9, 2014
  Developer:  Julian Werfel
 */
package gov.va.med.imaging.hydra.web;

import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.enums.ImageFormat;
import gov.va.med.imaging.exchange.enums.ImageQuality;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Julian Werfel
 *
 */
public class ImageServlet
extends AbstractHydraImageServlet
{

	private static final long serialVersionUID = 1746653124236216680L;


	/* (non-Javadoc)
	 * @see gov.va.med.imaging.hydra.web.AbstractHydraImageServlet#getAcceptableResponseContent()
	 */
	@Override
	protected List<ImageFormat> getAcceptableResponseContent(HttpServletRequest request)
	throws MethodException
	{
		List<ImageFormat> acceptableResponseContent = new ArrayList<ImageFormat>();		
		String contentType = request.getParameter("contentType");
		if(contentType != null && contentType.length() > 0)
		{
			List<ImageFormat> parsedFormats = parseImageFormatList(contentType);
			acceptableResponseContent.addAll(parsedFormats);
		}
		else
		{		
			acceptableResponseContent.add(ImageFormat.DICOM);
			acceptableResponseContent.add(ImageFormat.TGA);
		}
		acceptableResponseContent.add(ImageFormat.ORIGINAL);
		return acceptableResponseContent;
	}
	
	private List<ImageFormat> parseImageFormatList(String imageFormatList)
	{
		List<ImageFormat> formats = new ArrayList<ImageFormat>();
		for(StringTokenizer commaTokenizer = new StringTokenizer(imageFormatList, ","); commaTokenizer.hasMoreTokens();)
		{
			formats.add(ImageFormat.valueOfMimeType(commaTokenizer.nextToken().trim()));
		}
		return formats;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.hydra.web.AbstractHydraImageServlet#getImageQuality()
	 */
	@Override
	protected ImageQuality getImageQuality(HttpServletRequest request)
	{
		String imageQualityString = request.getParameter("imageQuality");
		if(imageQualityString == null || imageQualityString.length() == 0)
			return ImageQuality.DIAGNOSTICUNCOMPRESSED;
		
		return ImageQuality.getImageQuality(imageQualityString);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.hydra.web.AbstractHydraImageServlet#getOperationName()
	 */
	@Override
	protected String getOperationName()
	{
		return "getImage";
	}
}
