/**
 * 
  Property of ISI Group, LLC
  Date Created: May 9, 2014
  Developer:  Julian Werfel
 */
package gov.va.med.imaging.hydra.rest;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.encryption.exceptions.AesEncryptionException;
import gov.va.med.imaging.hydra.commands.GetPatientRadiologyStudiesCommand;
import gov.va.med.imaging.hydra.commands.GetPatientsCommand;
import gov.va.med.imaging.hydra.commands.GetStudyCommand;
import gov.va.med.imaging.rest.types.RestBooleanReturnType;
import gov.va.med.imaging.rest.types.RestStringType;
import gov.va.med.imaging.tomcat.vistarealm.encryption.EncryptionToken;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.transactioncontext.TransactionContextHttpHeaders;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

/**
 * @author Julian Werfel
 *
 */
@Path("hydra")
public class HydraServices
{

	@GET
	@Path("study/{studyId}")
	@Produces(MediaType.APPLICATION_XML)
	@Consumes(MediaType.APPLICATION_XML)
	public Response getRadiologyOrderStudy(			
			@PathParam("studyId") String studyId)
	throws MethodException, ConnectionException
	{
		return wrapResponse(new GetStudyCommand(studyId).execute());
	}
	
	@GET
	@Path("patients/{siteId}")
	@Produces(MediaType.APPLICATION_XML)
	@Consumes(MediaType.APPLICATION_XML)
	public Response getPatients(			
			@PathParam("siteId") String siteId,
			@QueryParam("searchText") String searchText)
	throws MethodException, ConnectionException
	{
		return wrapResponse(new GetPatientsCommand(siteId, searchText).execute());
	}
	
	@GET
	@Path("studies/{siteId}/{patientIcn}")
	@Produces(MediaType.APPLICATION_XML)
	@Consumes(MediaType.APPLICATION_XML)
	public Response getPatientRadiologyStudies(			
			@PathParam("siteId") String siteId,
			@PathParam("patientIcn") String patientIcn)
	throws MethodException, ConnectionException
	{
		return wrapResponse(new GetPatientRadiologyStudiesCommand(siteId, patientIcn).execute());
	}
	
	@GET
	@Path("user/validateToken")
	@Produces(MediaType.APPLICATION_XML)
	public Response validateToken()
	throws MethodException, ConnectionException
	{
		// if it gets here then it went through the filter and the token is fine
		return wrapResponse(new RestBooleanReturnType(true));
	}
	
	@GET
	@Path("user/token")
	@Produces(MediaType.APPLICATION_XML)
	public Response createToken()
	throws MethodException, ConnectionException
	{
		// must be in here using a secure method
		try
		{
			return wrapResponse(new RestStringType(EncryptionToken.encryptUserCredentials()));
		}
		catch(AesEncryptionException aesX)
		{
			throw new MethodException(aesX);
		}
	}
	
	private Response wrapResponse(Object result)
	throws MethodException
	{
		return Response.status(Status.OK).header(TransactionContextHttpHeaders.httpHeaderMachineName, 
				TransactionContextFactory.get().getMachineName()).entity(result).build();
	}

}
