/**
 * 
  Property of ISI Group, LLC
  Date Created: May 9, 2014
  Developer:  Julian Werfel
 */
package gov.va.med.imaging.hydra.commands;

import gov.va.med.URNFactory;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.hydra.HydraRouter;
import gov.va.med.imaging.hydra.rest.types.HydraRestTranslator;
import gov.va.med.imaging.hydra.rest.types.HydraStudyType;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

import java.util.Map;

/**
 * @author Julian Werfel
 *
 */
public class GetStudyCommand
extends AbstractHydraCommand<ArtifactResults, HydraStudyType>
{
	private final String studyId;

	/**
	 * @param methodName
	 */
	public GetStudyCommand(String studyId)
	{
		super("getStudy");
		this.studyId = studyId;
	}

	public String getStudyId()
	{
		return studyId;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#executeRouterCommand()
	 */
	@Override
	protected ArtifactResults executeRouterCommand() 
	throws MethodException, ConnectionException
	{
		try
		{
			HydraRouter router = getRouter();
			StudyURN studyUrn = URNFactory.create(getStudyId(), StudyURN.class);
			StudyFilter filter = new StudyFilter(studyUrn);
			TransactionContext transactionContext = TransactionContextFactory.get();
			transactionContext.setPatientID(studyUrn.getPatientId());
			transactionContext.setUrn(getStudyId());
			return router.getStudyWithImages(studyUrn, studyUrn.getThePatientIdentifier(), filter, true, false);
		}
		catch(URNFormatException urnfX)
		{
			throw new MethodException(urnfX);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getMethodParameterValuesString()
	 */
	@Override
	protected String getMethodParameterValuesString()
	{
		return getStudyId();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#translateRouterResult(java.lang.Object)
	 */
	@Override
	protected HydraStudyType translateRouterResult(ArtifactResults routerResult)
	throws TranslationException, MethodException
	{
		return HydraRestTranslator.translate(routerResult);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getResultClass()
	 */
	@Override
	protected Class<HydraStudyType> getResultClass()
	{
		return HydraStudyType.class;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getTransactionContextFields()
	 */
	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getEntriesReturned(java.lang.Object)
	 */
	@Override
	public Integer getEntriesReturned(HydraStudyType translatedResult)
	{
		return translatedResult == null ? 0 : 1;
	}
}
