/**
 * 
  Property of ISI Group, LLC
  Date Created: May 13, 2014
  Developer:  Julian Werfel
 */
package gov.va.med.imaging.hydra.commands;

import gov.va.med.imaging.hydra.HydraContext;
import gov.va.med.imaging.hydra.HydraRouter;
import gov.va.med.imaging.web.commands.AbstractWebserviceCommand;

/**
 * @author Julian Werfel
 *
 */
public abstract class AbstractHydraCommand<D, E extends Object>
extends AbstractWebserviceCommand<D, E>
{

	/**
	 * @param methodName
	 */
	public AbstractHydraCommand(String methodName)
	{
		super(methodName);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getRouter()
	 */
	@Override
	protected HydraRouter getRouter()
	{
		return HydraContext.getRouter();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getRequestTypeAdditionalDetails()
	 */
	@Override
	protected String getRequestTypeAdditionalDetails()
	{
		return null;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getWepAppName()
	 */
	@Override
	protected String getWepAppName()
	{
		return "Hydra Web App";
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#setAdditionalTransactionContextFields()
	 */
	@Override
	public void setAdditionalTransactionContextFields()
	{
		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getInterfaceVersion()
	 */
	@Override
	public String getInterfaceVersion()
	{
		return "V1";
	}

}
