/**
 * 
 */
package gov.va.med.imaging.federation.proxy.v6;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.imaging.CprsIdentifier;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.federation.proxy.v5.FederationRestExternalPackageProxyV5;
import gov.va.med.imaging.federation.rest.endpoints.FederationExternalPackageRestUri;
import gov.va.med.imaging.federation.rest.proxy.FederationRestPostClient;
import gov.va.med.imaging.federation.rest.translator.FederationRestTranslator;
import gov.va.med.imaging.federation.rest.types.FederationCprsIdentifiersType;
import gov.va.med.imaging.federation.rest.types.FederationStudyType;
import gov.va.med.imaging.federationdatasource.configuration.FederationConfiguration;
import gov.va.med.imaging.proxy.services.ProxyServiceType;
import gov.va.med.imaging.proxy.services.ProxyServices;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

import javax.ws.rs.core.MediaType;

/**
 * @author William Peterson
 *
 */
public class FederationRestExternalPackageProxyV6 
extends FederationRestExternalPackageProxyV5 {

	/**
	 * @param proxyServices
	 * @param federationConfiguration
	 */
	public FederationRestExternalPackageProxyV6(ProxyServices proxyServices,
			FederationConfiguration federationConfiguration) {
		super(proxyServices, federationConfiguration);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.rest.proxy.AbstractFederationRestImageProxy#getProxyServiceType()
	 */
	@Override
	protected ProxyServiceType getProxyServiceType()
	{
		return ProxyServiceType.externalpackage;
	}

	
	@Override
	protected String getDataSourceVersion()
	{
		return "6";
	}

	public List<Study> postStudiesFromCprsIdentifiers(
			RoutingToken globalRoutingToken,
			PatientIdentifier patientIdentifier,
			List<CprsIdentifier> cprsIdentifiers) throws MethodException,
			ConnectionException {
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().debug("executing postStudiesFromCprsIdentifiers method in FederationRestExternalPackageProxyV6.");
		getLogger().info("postStudiesFromCprsIdentifiers, Transaction [" + transactionContext.getTransactionId() + "] initiated, patient Icn '" + patientIdentifier.getValue() + "' to '" + globalRoutingToken.toRoutingTokenString() + "'.");
		setDataSourceMethodAndVersion("postStudiesFromCprsIdentifiers");
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{patientIcn}", patientIdentifier.getValue());
		
		FederationCprsIdentifiersType federationCprsIdentifiers = FederationRestTranslator.translateCprsIdentifierList(cprsIdentifiers);
		
		String url = getWebResourceUrl(FederationExternalPackageRestUri.postStudiesFromCprsMethodPath, urlParameterKeyValues );
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		FederationStudyType[] studiesType = null;
        try
        {
               studiesType = postClient.executeRequest(FederationStudyType[].class, federationCprsIdentifiers);
        }
        catch(ConnectionException ex)
        {
               String msg = ex.getMessage();
               if(msg != null && msg.contains("XMLStreamException: ParseError"))
               {
                     getLogger().info("Got ConnectionException indicating parse error. This means no studies were returned, returning empty studyResult");
                     
                     List<Study> studyResult = new ArrayList<Study>(0);
                     return studyResult;
               }
               throw ex;
        }

		getLogger().info("postStudiesFromCprsIdentifiers, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (studiesType == null ? "null" : studiesType.length) + "] study webservice objects.");
		try
		{
			List<Study> studyResult = null;
			if(studiesType != null){
				SortedSet<Study> result = FederationRestTranslator.translate(studiesType);
				studyResult = new ArrayList<Study>(result.size());
				studyResult.addAll(result);
			}
			else{
                studyResult = new ArrayList<Study>(0);				
			}
			getLogger().info("postStudiesFromCprsIdentifiers, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (studyResult == null ? "null" : studyResult.size()) + "] study business objects.");
			return studyResult;
		}
		catch(TranslationException tX)
		{
			getLogger().error("Error in postStudiesFromCprsIdentifiers", tX);
			throw new MethodException(tX);
		}

	
	}

}
