package gov.va.med.imaging.mix.business;

import gov.va.med.imaging.mix.business.fhir.Series;

import java.io.Serializable;
import java.util.Comparator;

/**
 * 
 * A Comparator class to assure that the Study remains in order of ien relation 
 * 
 * @author VACOTITTOC
 *
 */
public class SeriesComparator implements Comparator<Series>, Serializable {
	
	private static final long serialVersionUID = 4739063635641777002L;

	public int compare(Series series1, Series series2)
	{
		// JMW 3/12/08 - reversing the order of the sorts (was causing the series to be in descending order instead of ascending)
		int ienRelation = series1.getSeriesIen().compareTo(series2.getSeriesIen());
		int numberRelation = 0;
		int seriesUidRelation = series1.getUid().compareTo(series2.getUid());
		
		try
		{
			Integer series1Number = Integer.parseInt(series1.getNumber());
			Integer series2Number = Integer.parseInt(series2.getNumber());
			numberRelation = series1Number.compareTo(series2Number);
		}
		catch(Exception ex)
		{
			if(series1.getNumber() != null)
			{
				numberRelation = series1.getNumber().compareTo(series2.getNumber());
			}
		}
		
		return numberRelation != 0 ? numberRelation :
			ienRelation != 0 ? ienRelation :
				seriesUidRelation;
		/*
		return ienRelation != 0 ? ienRelation :
			seriesUidRelation != 0 ? seriesUidRelation :
				numberRelation;
				*/
	}
}
