/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Nov 13, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.web;

import gov.va.med.imaging.awiv.client.ui.widgets.AwivConstants;
import gov.va.med.imaging.encryption.exceptions.AesEncryptionException;
import gov.va.med.imaging.tomcat.vistarealm.encryption.EncryptionToken;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * @author vhaiswwerfej
 *
 */
public class UserFilter 
implements Filter
{
	private final Logger logger = Logger.getLogger(UserFilter.class);

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#destroy()
	 */
	@Override
	public void destroy() 
	{
			
	}

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) 
	throws IOException, ServletException 
	{
		try
		{
			if(request instanceof HttpServletRequest)
			{
				HttpServletRequest req = (HttpServletRequest)request;
				Cookie [] cookies = req.getCookies();
				String encryptedUserInformation = null;
				if(cookies != null)
				{
					for(Cookie cookie : cookies)
					{
						if(AwivConstants.userCookieName.equals(cookie.getName()))
						{
							encryptedUserInformation = cookie.getValue();
							break;
						}
					}
				}
				if(encryptedUserInformation != null)
				{
					try
					{
						EncryptionToken.decryptUserCredentials(encryptedUserInformation);
					}
					catch(AesEncryptionException arX)
					{
						logger.error(arX);
						unauthenticatedResponse(response);
						return;
					}	
				}
				else
				{
					unauthenticatedResponse(response);
					return;
				}	
			}
			chain.doFilter(request, response);					
		}
		finally
		{
			// always must clear (if it exists)
			if(TransactionContextFactory.isTransactionContextEstablished())
				TransactionContextFactory.get().clear();
		}		
	}

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	@Override
	public void init(FilterConfig filterConfig) 
	throws ServletException 
	{	
		
	}
	
	protected void unauthenticatedResponse(ServletResponse response)
	throws IOException
	{
		if(response instanceof HttpServletResponse)
		{
			logger.info("redirecting to /Awiv");
			HttpServletResponse resp = (HttpServletResponse)response;
			resp.sendRedirect("/Awiv");		
		}
	}
}
