/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 1, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  VHAISWWERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.web;

import gov.va.med.imaging.encryption.AesEncryption;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmPrincipal.AuthenticationCredentialsType;
import gov.va.med.imaging.tomcat.vistarealm.encryption.EncryptionToken;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmSecurityContext;
import gov.va.med.imaging.transactioncontext.ClientPrincipal;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author VHAISWWERFEJ
 *
 */
public class ExternalSiteServlet
extends HttpServlet
{
	private static final long serialVersionUID = -6637996228946923231L;

	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		
		/*
		 * awivParameters.append("&F{" + context.getFullName() + "}");
    	awivParameters.append("&G{" + context.getDuz() + "}");
    	awivParameters.append("&H{" + context.getSsn() + "}");
    	awivParameters.append("&I{" + context.getSiteName() + "}");
    	awivParameters.append("&J{" + context.getSiteNumber() + "}");    	
		awivParameters.append("&K{" + context.getBrokerSecurityToken() + "}"); // place holder saved for BSE token
		awivParameters.append("&C{" + patientIcn + "}");
		 */
		try
		{
			String encryptedParameters = request.getParameter("input");
			String decryptedParameters = AesEncryption.decodeByteArray(encryptedParameters);
			
			String patientIcn = getParameter("C", decryptedParameters);
			String duz = getParameter("G", decryptedParameters);
			String fullname = getParameter("F", decryptedParameters);
			String ssn = getParameter("H", decryptedParameters);
			String sitename = getParameter("I", decryptedParameters);
			String sitenumber = getParameter("J", decryptedParameters);
			String bseToken = getParameter("K", decryptedParameters);			
			
			validateRequiredField("duz", duz);
			validateRequiredField("fullname", fullname);
			validateRequiredField("ssn", ssn);
			validateRequiredField("sitename", sitename);
			validateRequiredField("sitenumber", sitenumber);
			//validateRequiredField("bseToken", bseToken);		
		
			ClientPrincipal principal = new ClientPrincipal(
					sitenumber, true,AuthenticationCredentialsType.Password, 
					null, null,
					duz, fullname, ssn, sitenumber, sitename,
					new ArrayList<String>(),
					new HashMap<String, Object>()
			);
			principal.setAuthenticatedByVista(false); // no credentials in this case
			VistaRealmSecurityContext.set(principal);
			
			TransactionContext transactionContext = TransactionContextFactory.get(); 
			transactionContext.setBrokerSecurityApplicationName("VISTA IMAGING VIX");
			transactionContext.setBrokerSecurityToken(bseToken);
			
			Cookie cookie = new Cookie("user", EncryptionToken.encryptUserCredentials());
			cookie.setPath("/Awiv");
			//cookie.setSecure(true);
			cookie.setMaxAge(-1); // don't persist between sessions
			response.addCookie(cookie);
			
			if(patientIcn != null && patientIcn.length() > 0)
			{
				Cookie patientCookie = new Cookie("patient", patientIcn);
				patientCookie.setMaxAge(-1);
				patientCookie.setPath("/Awiv");
				response.addCookie(patientCookie);
			}
			
			String url = "Awiv.html";
			response.sendRedirect(url);
		}
		catch(Exception ex)
		{
			throw new ServletException(ex);
		}
	}
	
	private void validateRequiredField(String fieldName, String fieldValue)
	throws ServletException
	{
		if(fieldValue == null || fieldValue.length() <= 0)
			throw new ServletException("Required field '" + fieldName + "' is missing and is required.");
	}
	
	private String getParameter(String parameter, String input)
	{
		String beginingSearchString = "&" + parameter + "{";
		String endSearchString = "}";
		
		if(input == null)
			return null;
		int loc = input.indexOf(beginingSearchString);
		if(loc < 0)
			return null;
		int endLoc = input.indexOf(endSearchString, loc + 3);
		return input.substring(loc + 3, endLoc);
	}
}
