/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 8, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.query;

import gov.va.med.imaging.exchange.FileTypeIdentifierStream;
import gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

/**
 * Implementation of a data source that is backed by a DocumentRetrieveResult object.
 * 
 * @author vhaiswwerfej
 *
 */
public class DocumentRetrieveDataSource 
implements DataSource
{
	private final DocumentRetrieveResult documentRetrieveResult;
	private String contentType = null;
	
	public DocumentRetrieveDataSource(DocumentRetrieveResult documentRetrieveResult)
	{
		this.documentRetrieveResult = documentRetrieveResult;
	}

	/* (non-Javadoc)
	 * @see javax.activation.DataSource#getContentType()
	 */
	@Override
	public synchronized String getContentType() 
	{
		if(contentType == null && documentRetrieveResult != null)
		{
			InputStream inputStream = documentRetrieveResult.getDocumentStream();
			if(inputStream instanceof FileTypeIdentifierStream)
			{
				FileTypeIdentifierStream ftis = (FileTypeIdentifierStream)inputStream;
				contentType = ftis.getImageFormat().getMime();
			}
		}
		return contentType;
	}

	/* (non-Javadoc)
	 * @see javax.activation.DataSource#getInputStream()
	 */
	@Override
	public InputStream getInputStream() 
	throws IOException 
	{
		return documentRetrieveResult.getDocumentStream();
	}

	/* (non-Javadoc)
	 * @see javax.activation.DataSource#getName()
	 */
	@Override
	public String getName() {
		return documentRetrieveResult.getDocumentIdentifier().toString();
	}

	/* (non-Javadoc)
	 * @see javax.activation.DataSource#getOutputStream()
	 */
	@Override
	public OutputStream getOutputStream() throws IOException 
	{
		throw new IOException("Cannot write to output stream");
	}

}
