/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.ihe;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class XCAWebAppRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public XCAWebAppRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientSensitiveValue(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientSensitivityLevelCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.PatientSensitiveValue.class, 
	 				"GetPatientSensitivityLevelCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientSensitivityLevelCommand' in method 'getPatientSensitiveValue' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocument(
 			gov.va.med.imaging.DocumentURN documentUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentCommand' and parameters 'gov.va.med.imaging.DocumentURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.DocumentURN.class 
		  			},
 					new Object[]{
				 		documentUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentCommand' in method 'getDocument' with parameters 'gov.va.med.imaging.DocumentURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postTransactionLogEntry(
 			gov.va.med.imaging.access.TransactionLogEntry entry
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostTransactionLogEntryCommand' and parameters 'gov.va.med.imaging.access.TransactionLogEntry'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostTransactionLogEntryCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.access.TransactionLogEntry.class 
		  		},
				new Object[]{
			 		entry
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostTransactionLogEntryCommand' in method 'postTransactionLogEntry' with parameters 'gov.va.med.imaging.access.TransactionLogEntry'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postTransactionLogEntryImmediate(
 			gov.va.med.imaging.access.TransactionLogEntry entry
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostTransactionLogEntryCommand' and parameters 'gov.va.med.imaging.access.TransactionLogEntry'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostTransactionLogEntryCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogEntry.class 
		  			},
 					new Object[]{
				 		entry
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostTransactionLogEntryCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetResultForPatient(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentSetResultForPatientCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,documentFilter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentSetResultForPatientCommand' in method 'getDocumentSetResultForPatient' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDocumentAccessEventRetryable(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostImageAccessEventRetryableCommand' and parameters 'gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostImageAccessEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  		},
				new Object[]{
			 		event
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostImageAccessEventRetryableCommand' in method 'postDocumentAccessEventRetryable' with parameters 'gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
			
 		}

 }