/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.ihe;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class XCAWebAppRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements XCAWebAppRouter
 {
	private static XCAWebAppRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized XCAWebAppRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new XCAWebAppRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected XCAWebAppRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.PatientSensitiveValue getPatientSensitiveValue(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.PatientSensitiveValue> command = (Command<gov.va.med.imaging.exchange.business.PatientSensitiveValue>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.PatientSensitiveValue.class, 
	 				"GetPatientSensitivityLevelCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientSensitivityLevelCommand");
		
      
        gov.va.med.imaging.exchange.business.PatientSensitiveValue commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult getDocument(
 			gov.va.med.imaging.DocumentURN documentUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.DocumentURN.class 
		  			},
 					new Object[]{
				 		documentUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentCommand");
		
      
        gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postTransactionLogEntry(
 			gov.va.med.imaging.access.TransactionLogEntry entry
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostTransactionLogEntryCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.access.TransactionLogEntry.class 
		  		},
				new Object[]{
			 		entry
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postTransactionLogEntryImmediate(
 			gov.va.med.imaging.access.TransactionLogEntry entry
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostTransactionLogEntryCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogEntry.class 
		  			},
 					new Object[]{
				 		entry
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostTransactionLogEntryCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentSetResult getDocumentSetResultForPatient(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,documentFilter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentSetResultForPatientCommand");
		
      
        gov.va.med.imaging.exchange.business.documents.DocumentSetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDocumentAccessEventRetryable(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostImageAccessEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  		},
				new Object[]{
			 		event
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 }