/**
 * 
 */
package org.ihe.iti.xdsb.adb;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import junit.framework.Assert;
import junit.framework.TestCase;

/**
 * @author vhaiswbeckec
 *
 */
public class TestRetrieveDocumentSetResponse
extends TestCase
{
	private static String[] positiveTests = new String[]
	{
		"HAIMSRetrieveResponse001.xml"
	};
	
	@Override
	protected void setUp() throws Exception
	{
		super.setUp();
	}

	@Override
	protected void tearDown() throws Exception
	{
		super.tearDown();
	}

	/**
	 * 
	 */
	public void testPositiveParse()
	{
		boolean success = true;
		for(String resourceName : positiveTests)
		{
			try
			{
				parseDocument(resourceName);
			}
			catch (Exception x)
			{
				x.printStackTrace();
				success = false;
			}
		}
		
		if(!success)
			Assert.fail();
	}
	
	private void parseDocument(String resourceName) 
	throws Exception
	{
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
	    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
	    XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream);
	    
	    RetrieveDocumentSetResponse rdsr = RetrieveDocumentSetResponse.Factory.parse(reader);
	    RetrieveDocumentSetResponseType rdsrt = rdsr.getRetrieveDocumentSetResponse();
	}
}
