/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 24, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe;

import org.oasis.ebxml.regrep.rs.xmlbeans.RegistryErrorDocument;

import gov.va.med.imaging.exchange.business.ArtifactResultError;
import gov.va.med.imaging.exchange.enums.ArtifactResultErrorCode;
import gov.va.med.imaging.exchange.enums.ArtifactResultErrorSeverity;
import gov.va.med.imaging.ihe.xds.ErrorCode;

/**
 * @author DNS
 *
 */
public class XcaArtifactResultError 
implements ArtifactResultError
{
	private final String codeContext;
	private final String severity;
	private final String location;
	private final String errorCode;
	
	public XcaArtifactResultError(RegistryErrorDocument.RegistryError registryError)
	{
		this.codeContext = registryError.getCodeContext();
		this.severity = registryError.getSeverity();
		this.location = registryError.getLocation();
		this.errorCode = registryError.getErrorCode(); 
	}
	
	
	public String getCodeContext()
	{
		return codeContext;
	}

	public ArtifactResultErrorSeverity getSeverity()
	{
		//TODO: need to convert this to a severity
		return ArtifactResultErrorSeverity.error;
	}

	public String getLocation()
	{
		return location;
	}

	public ArtifactResultErrorCode getErrorCode()
	{
		if(ErrorCode.UNKNOWN_PATIENT_ID.getOpcode().equals(errorCode))
		{
			return ArtifactResultErrorCode.unknownPatientId;
		}
		else if(ErrorCode.REGISTRY_METADATA_ERROR.getOpcode().equals(errorCode))
		{
			return ArtifactResultErrorCode.invalidRequestException;
		}
		//TODO: need to convert this to an error code
		return ArtifactResultErrorCode.internalException;
	}

}
