/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jul 20, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe;

import gov.va.med.imaging.ihe.exceptions.TranslationException;
import gov.va.med.imaging.ihe.xca.XcaTimeZone;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Represents a document as part of the Query response
 * 
 * @author DNS
 *
 */
public class XCAQueryResponseDocumentProperties 
{
	private Map<String, String> properties = new HashMap<String, String>();  

	public static XCAQueryResponseDocumentProperties translate(org.oasis.ebxml.regrep.rim.xmlbeans.SlotType1[] slots)
	{
		XCAQueryResponseDocumentProperties props = new XCAQueryResponseDocumentProperties(slots);
		
		return props;		
	}
	
	protected XCAQueryResponseDocumentProperties(org.oasis.ebxml.regrep.rim.xmlbeans.SlotType1 [] slots)
	{
		for(org.oasis.ebxml.regrep.rim.xmlbeans.SlotType1 slot : slots)			
		{			
			String key = slot.getName();
			org.oasis.ebxml.regrep.rim.xmlbeans.ValueListType valueList = slot.getValueList();
			String[] values = valueList.getValueArray();
			if(values != null && values.length > 0)
				properties.put(key, values[0]);
		}
	}

	public String getUrn()
	{
		return getValueAsString(QuerySlotName.URI.toString());
	}
	
	public String getLanguageCode()
	throws TranslationException
	{
		return getValueAsString(QuerySlotName.languageCode.toString());
	}
	
	public Date getCreationTime()
	throws ParseException
	{
		SimpleDateFormat dateFormatter = new SimpleDateFormat(AbstractXCATranslator.iheDateFormat);
		dateFormatter.setTimeZone(XcaTimeZone.getTimeZone());
		return getValueAsDate(QuerySlotName.creationTime.toString(), dateFormatter);
	}
	
	public String getSourcePatientId()
	{
		return getValueAsString(QuerySlotName.sourcePatientId.toString());
	}
	
	/**
	 * @return
	 */
	public String getRepositoryId()
	{
		return getValueAsString(QuerySlotName.repositoryUniqueId.toString());
	}
	
	// the hash value may be up to 40 hex characters long (160 bits is the result of an SHA-1 hash)
	// 
	public BigInteger getHash()
	throws NumberFormatException
	{
		return getValueAsBigInteger(QuerySlotName.hash.toString());
	}
	
	public Long getSize()
	throws NumberFormatException
	{
		return getValueAsLong(QuerySlotName.size.toString());
	}
	
	@SuppressWarnings("boxing")
	private Long getValueAsLong(String propertyName)
	{
		String stringValue = getValueAsString(propertyName);
		try
		{
			return stringValue == null || stringValue.length() == 0 ? null : new Long(stringValue);
		}
		catch (NumberFormatException x)
		{
			// an NFE may indicate that it is in hex
			return Long.parseLong(stringValue, 16);
		}
	}
	private BigInteger getValueAsBigInteger(String propertyName)
	{
		String stringValue = getValueAsString(propertyName);
		try
		{
			return stringValue == null || stringValue.length() == 0 ? null : new BigInteger(stringValue, 10);
		}
		catch (NumberFormatException x)
		{
			// an NFE may indicate that it is in hex
			return new BigInteger(stringValue, 16);
		}
	}
	
	private Date getValueAsDate(String propertyName, SimpleDateFormat dateFormatter)
	throws ParseException
	{
		String stringValue = getValueAsString(propertyName);
		return stringValue == null ? null : dateFormatter.parse(stringValue);
	}
	
	private String getValueAsString(String propertyName)
	{
		return properties.get(propertyName);
		
	}
}
