package gov.va.med.imaging.ihe;

/**
 * An immutable value object representing the parts of an external reference
 */
class ExternalReferenceValueObject
{
	private final String registryObjectId;
	private final String externalIdentifierName;		// e.g. "XDSDocumentEntry.uniqueId" 
	private final String externalIdentifierValue;		// e.g. "1.3.6.1.4.1.21367.2005.3.99.1.1010"
	private final String identificationScheme;		// e.g. "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab"
	private final String description;
	
	/**
	 * @param registryObjectId
	 * @param externalIdentifierName
	 * @param externalIdentifierValue
	 * @param identificationScheme
	 * @param description
	 */
	public ExternalReferenceValueObject(String registryObjectId, String externalIdentifierName,
		String externalIdentifierValue, String identificationScheme, String description)
	{
		super();
		this.registryObjectId = registryObjectId;
		this.externalIdentifierName = externalIdentifierName;
		this.externalIdentifierValue = externalIdentifierValue;
		this.identificationScheme = identificationScheme;
		this.description = description;
	}

	public String getRegistryObjectId()
	{
		return this.registryObjectId;
	}

	public String getExternalIdentifierName()
	{
		return this.externalIdentifierName;
	}

	public String getExternalIdentifierValue()
	{
		return this.externalIdentifierValue;
	}

	public String getIdentificationScheme()
	{
		return this.identificationScheme;
	}

	public String getDescription()
	{
		return this.description;
	}
}