/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 24, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.datasource.test;

import gov.va.med.GlobalArtifactIdentifier;
import gov.va.med.GlobalArtifactIdentifierFactory;
import gov.va.med.URNFactory;
import gov.va.med.imaging.DocumentURN;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.business.LocalizedSiteTestImpl;
import gov.va.med.imaging.core.interfaces.LocalizedSite;
import gov.va.med.imaging.datasource.DocumentDataSourceSpi;
import gov.va.med.imaging.exchange.business.ImageStreamResponse;
import gov.va.med.imaging.exchange.business.SiteImpl;

import java.net.MalformedURLException;

/**
 * THIS IS NOT A JUNIT TEST!
 * 
 * @author DNS
 *
 */
public class XCARetrieveDataSourceTest
extends AbstractXCADataSourceTest
{
	
	/**
	 * @param args
	 */
	public static void main(String[] args) 
	{
		initializeLogging();
		initializeConnectionHandlers();
		initializeTransactionContext();
		
		 XCARetrieveDataSourceTest test = new XCARetrieveDataSourceTest();
		 try
		{
			test.testXcaDocumentRetrieveFromVA(getTestVAResolvedSite(), "xca");
		}
		catch (MalformedURLException x)
		{
			x.printStackTrace();
		}
	}
	
	/**
	 * 
	 */
	public void testXcaDocumentRetrieveFromVA(
		ResolvedArtifactSource artifactSource, 
		String protocol)
	{
		try
		{
			DocumentDataSourceSpi spi = getProvider().createDocumentDataSource(artifactSource, protocol);

			// for testing against a VA document
			DocumentURN documentURN = URNFactory.create("urn:vadoc:660-GEYDANBU-GEYDANBT-1006184063V088473", DocumentURN.class);
			ImageStreamResponse isr = spi.getDocument(documentURN);
			
			// for testing against a VA document
			//DocumentURN documentURN = DocumentURN.create("urn:vadoc:660-GEYDANBU-GEYDANBT-1006184063V088473");
			//ImageStreamResponse isr = spi.getDocument(documentURN);
			
			if (isr != null)
			{
				System.out.print("Image Format: " + isr.getImageFormat()+ "\n");
				System.out.print("Image Quality: " + isr.getImageQuality()+ "\n");
				System.out.print("Text Checksum: " + isr.getTxtChecksum() + "\n");
				isr.getImageStream().getInputStream().close();
			}
			else
			{
				System.out.print("ERROR - expected to receive an image stream, but did not...");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	public void testXcaDocumentRetrieveFromDoD(
		ResolvedArtifactSource artifactSource, 
		String protocol)
	{
		try
		{
			DocumentDataSourceSpi spi = getProvider().createDocumentDataSource(artifactSource, protocol);

			// for testing against a DoD document
			String homeCommunityUid = "2.16.840.1.113883.3.42.10012.100001.206";
			String repositoryUniqueId = "TestHaimsRepositoryId";
			String[] documentIds = new String[]
			{
					"4273774969d942c99a98803f12427a52",
					"75396abfb99b4084aba8bee64da436e8",
					"6f30b9a241fa4345b0ef9180642e1f2d",
					"22a96e2906be40cc8939e83a5c5cc7b7",
					"87e8677d44ad4f3da9093e42badc0505",
					"4a8b12366bb3449b9b042f1f0c93c554"
			};
			//String homeCommunityUid = "2.16.840.1.113883.3.42.10012.100001.206";
			//String repositoryUniqueId = "TestHaimsRepositoryId";
			//String documentId = "4c89e4b08a7a499580232835fbe75fe8";
			//ImageStreamResponse isr = spi.getDocument(homeCommunityUid, repositoryUniqueId, documentId);

			for(String documentId : documentIds)
			{
				GlobalArtifactIdentifier gai = GlobalArtifactIdentifierFactory.create(homeCommunityUid, 
						repositoryUniqueId, documentId);				
				ImageStreamResponse isr = spi.getDocument(gai);
	
				// for testing against a VA document
				//DocumentURN documentURN = DocumentURN.create("urn:vadoc:660-GEYDANBU-GEYDANBT-1006184063V088473");
				//ImageStreamResponse isr = spi.getDocument(documentURN);
				
				if (isr != null)
				{
					System.out.print("Image Format: " + isr.getImageFormat()+ "\n");
					System.out.print("Image Quality: " + isr.getImageQuality()+ "\n");
					System.out.print("Text Checksum: " + isr.getTxtChecksum() + "\n");
					isr.getImageStream().getInputStream().close();
				}
				else
				{
					System.out.print("ERROR - expected to receive an image stream, but did not...");
				}
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	private LocalizedSite getLocalizedSiteForDoD()
	{
		// Test VIX acting like the HAIMS gateway
		LocalizedSiteTestImpl site;
		try
		{
			site = new LocalizedSiteTestImpl(new SiteImpl("200", "DoD", "DOD", null, 0, "vhaiswimmixvix3", 8080, ""));
		}
		catch (MalformedURLException x)
		{
			x.printStackTrace();
			return null;
		}

		// HAIMS through a local proxy (has not worked yet)
		//LocalizedSiteTestImpl site = new LocalizedSiteTestImpl(new SiteImpl("200", "DoD", "DOD", null, 0, "localhost", 1999, ""));

		// Sean's home web service instantiation
		//LocalizedSiteTestImpl site = new LocalizedSiteTestImpl(new SiteImpl("200", "DoD", "DOD", null, 0, "69.76.5.20", 8918, ""));
		
		// the Harris lab, only from within their network
		//LocalizedSiteTestImpl site = new LocalizedSiteTestImpl(new SiteImpl("200", "DoD", "DOD", null, 0, "158.147.211.240", 10700, ""));

		// Sean's server, only from within the Harris network
		//LocalizedSiteTestImpl site = new LocalizedSiteTestImpl(new SiteImpl("200", "DoD", "DOD", null, 0, "158.147.211.160", 80, ""));
		
		site.setLocalSite(true);
		return site;
	}

}
