/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 16, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.proxy;

import gov.va.med.*;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.NullOutputStream;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.channels.ByteStreamPump;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.datasource.DocumentDataSourceSpi;
import gov.va.med.imaging.datasource.DocumentSetDataSourceSpi;
import gov.va.med.imaging.datasource.Provider;
import gov.va.med.imaging.exceptions.OIDFormatException;
import gov.va.med.imaging.exchange.business.*;
import gov.va.med.imaging.exchange.business.documents.Document;
import gov.va.med.imaging.exchange.business.documents.DocumentSet;
import gov.va.med.imaging.exchange.business.documents.DocumentSetResult;
import gov.va.med.imaging.exchange.storage.DataSourceImageInputStream;
import gov.va.med.imaging.ihe.xca.datasource.configuration.XCADataSourceConfiguration;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmRoles;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmPrincipal.AuthenticationCredentialsType;
import gov.va.med.imaging.transactioncontext.ClientPrincipal;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;

/**
 * This is a dirt simple XCA client driver - this DOES NOT contain JUnit tests or any other unit tests
 * 
 * @author DNS
 *
 */
public class XcaTest
{
	//NCAT  - IP           (this should go to Evolvents ext IP of 67.90.191.177)
	//HAIMS DIT  IP            (this should go to Evolvents ext IP of 67.90.191.176)
	//HAIMS DEVINT  IP            (this should go to Evolvents ext IP of 67.90.191.165)

	public static final String LOCALHOST = 
		"xca://localhost:8443";
	public static final String LOCALHOST_URL = 
		"xca://localhost:8443/XCARespondingGateway/services/RespondingGateway_Service";
	public static final String SILVER_CVIX_URL = 
		"xca://IP              /XCARespondingGateway/services/RespondingGateway_Service";
	public static final String SILVER_NCAT_URL = 
		"xca://catbhie.mont.disa.mil/RespondingGateway.svc";
	public static final String SILVER_HAIMS_URL = 
		"xca://silver.haims:8080/XCA.WebService/RespondingGateway.svc";
	public static final String SILVER_BHIE_URL = 
		"xca://silver.bhie:7010/DocSearchXcaService/RespondingGateway_Service";
		//"xca://localhost:1963/DocSearchXcaService/RespondingGateway_Service";

	/**
	 * @param args
	 * @throws MethodException 
	 * @throws ConnectionException 
	 * @throws RoutingTokenFormatException 
	 * @throws OIDFormatException 
	 */
	public static void main(String[] args) 
	{
		String[] patientIcns;
		ProtocolHandlerUtility.initialize(true);
		
		//System.out.println("Handler packages were '" + initialHandlerPackages + "' and are now '" + handlerPackages + ".");
		System.out.println("Java version is '" + System.getProperty("java.specification.version") + "'.");
		System.out.println("Sun library path is '" + System.getProperty("sun.boot.library.path") + "'.");
		List<String> roles = new ArrayList<String>();
		roles.add(VistaRealmRoles.VistaUserRole.getRoleName());
		ClientPrincipal principal = new ClientPrincipal(
				"660", true, AuthenticationCredentialsType.Password, 
				"boating1", "boating1.", 
				"126", "IMAGPROVIDERONETWOSIX,ONETWOSIX", "843924956", "660", "Salt lake City", 
				roles, 
				new HashMap<String, Object>()
		);
		/*
		ClientPrincipal principal = new ClientPrincipal(
				"200", true, AuthenticationCredentialsType.Password, 
				"3205OBX", "silver.200", 
				"36213", "CVIX,USER", "123456777", "200", "Austin", 
				roles, 
				new HashMap<String, Object>()
		);
		*/
		principal.setAuthenticatedByVista(Boolean.TRUE);
		principal.setAuthenticatedByVista(Boolean.FALSE);
		TransactionContextFactory.createClientTransactionContext(principal);
	
		//Logger.getRootLogger().setLevel(Level.ERROR);
		//Logger.getLogger("org.apache.commons.httpclient.Wire").setLevel(Level.ALL);
		
		if(args.length > 0)
			patientIcns = args;
		else
			patientIcns = new String[]{"1006184063V088473"};
		
		XCADataSourceConfiguration configuration = null;
		try
		{
			configuration = XCADataSourceConfiguration.create(
				"file:///VixConfig/keystore.xca", "R00tbeer",
				"file:///VixConfig/truststore.xca", "R00tbeer",
				"xcas", 7443, true
			);
		}
		catch (MalformedURLException x1)
		{
			x1.printStackTrace();
			return;
		}
		
		try
		{
			XcaTest xcaTest = new XcaTest( createSourceMap() );
			//String patientIcn = "1008861107V475740", "1006184063V088473";
			xcaTest.queryAndRetrieveDocuments(patientIcns, true);
		}
		catch (Exception x)
		{
			x.printStackTrace();
		}
	}
	
	/**
	 * This map is the site resolution table (used in retrieve)
	 * @return
	 * @throws MalformedURLException
	 * @throws OIDFormatException 
	 * @throws RoutingTokenFormatException 
	 */
	private static SortedMap<RoutingToken, ResolvedArtifactSource> createSourceMap() 
	throws MalformedURLException, RoutingTokenFormatException, OIDFormatException
	{
		SortedMap<RoutingToken, ResolvedArtifactSource> sourceMap = new TreeMap<RoutingToken, ResolvedArtifactSource>();
		URL []urls = null;
		Site s = null;
		List<URL> metadataUrls = null;
		ResolvedSiteImpl site = null;
		
		// configure CVIX
		urls = new URL[] {new URL(LOCALHOST_URL)};
		s = new SiteImpl("VA", "660", "Washington DC", "WDC", urls);
		metadataUrls = new ArrayList<URL>();
		metadataUrls.add(urls[0]);	
		site = ResolvedSiteImpl.create(s, false, false, true, metadataUrls, metadataUrls);
		assert(site != null);
		sourceMap.put(
			RoutingTokenImpl.create( WellKnownOID.VA_DOCUMENT.getCanonicalValue(), "660" ), 
			site);
		
		// configure BHIE
		urls = new URL[] {new URL(SILVER_BHIE_URL)};
		s = new SiteImpl("DoD", "2002", "DoD", "DOD", urls);
		metadataUrls = new ArrayList<URL>();
		metadataUrls.add(urls[0]);	
		site = ResolvedSiteImpl.create(s, false, false, true, metadataUrls, metadataUrls);
		assert (site != null);
		sourceMap.put(
			RoutingTokenImpl.create( WellKnownOID.HAIMS_DOCUMENT.getCanonicalValue(), "*" ), 
			site);

		// configure HAIMS
		urls = new URL[] {new URL(SILVER_HAIMS_URL)};
		s = new SiteImpl("DoD", "2003", "DoD", "DOD", urls);
		metadataUrls = new ArrayList<URL>();
		metadataUrls.add(urls[0]);	
		site = ResolvedSiteImpl.create(s, false, false, true, metadataUrls, metadataUrls);
		assert(site != null);
		sourceMap.put(
			RoutingTokenImpl.create( WellKnownOID.HAIMS_DOCUMENT.getCanonicalValue(), "2.16.840.1.113883.3.198.2" ), 
			site);
		sourceMap.put(
			RoutingTokenImpl.create( WellKnownOID.HAIMS_DOCUMENT.getCanonicalValue(), "central" ), 
			site);
		
		// configure NCAT
		urls = new URL[] {new URL(SILVER_NCAT_URL)};
		s = new SiteImpl("DoD", "2004", "DoD", "DOD", urls);
		metadataUrls = new ArrayList<URL>();
		metadataUrls.add(urls[0]);	
		site = ResolvedSiteImpl.create(s, false, false, true, metadataUrls, metadataUrls);
		assert(site != null);
		sourceMap.put(
			RoutingTokenImpl.create( WellKnownOID.HAIMS_DOCUMENT.getCanonicalValue(), "2.16.840.1.113883.3.198.1" ), 
			site);
		
		return sourceMap;
	}
	
	// ===============================================================================================
	// 
	
	private final SortedMap<RoutingToken, ResolvedArtifactSource> sourceMap;
	private Provider provider;
	
	/**
	 * @param silverBhieUrl
	 */
	public XcaTest(SortedMap<RoutingToken, ResolvedArtifactSource> sourceMap)
	{
		this.sourceMap = sourceMap;
	}

	/**
	 * @return the endpoint
	 */
	protected SortedMap<RoutingToken, ResolvedArtifactSource> getSourceMap()
	{
		return this.sourceMap;
	}

	/**
	 * 
	 * @return
	 */
	protected synchronized Provider getProvider()
	{
		if(provider == null)
			provider = new Provider();
		
		return provider;
	}
	
	/**
	 * 
	 * @param homeCommunityId
	 * @param repositoryId
	 * @return
	 * @throws OIDFormatException
	 * @throws RoutingTokenFormatException
	 */
	protected ResolvedArtifactSource getResolvedArtifactSource(String homeCommunityId, String repositoryId) 
	throws OIDFormatException, RoutingTokenFormatException
	{
		return getResolvedArtifactSource( RoutingTokenImpl.create(homeCommunityId, repositoryId) );
	}	
	
	/**
	 * 
	 * @param routingToken
	 * @return
	 */
	protected ResolvedArtifactSource getResolvedArtifactSource(RoutingToken routingToken)
	{
		for( Iterator<Map.Entry<RoutingToken, ResolvedArtifactSource>> iterator = getSourceMap().entrySet().iterator();
			iterator.hasNext(); )
		{
			Map.Entry<RoutingToken, ResolvedArtifactSource> entry = iterator.next();
			if( entry.getKey().isIncluding(routingToken) )
				return entry.getValue();
		}
		return null;
	}

	/**
	 * 
	 * @param patientIcns
	 * @param retrieveDocuments
	 * @throws MethodException 
	 * @throws ConnectionException 
	 * @throws RoutingTokenFormatException 
	 * @throws OIDFormatException 
	 */
	public void queryAndRetrieveDocuments(String[] patientIcns, boolean retrieveDocuments) 
	throws OIDFormatException, RoutingTokenFormatException, ConnectionException, MethodException
	{
		for(String patientIcn : patientIcns)
		{
			SortedSet<DocumentSet> documentSets = queryForDocumentSets(patientIcn);
			if(retrieveDocuments)
				retrieveDocumentsFromDocumentSets(documentSets);
		}
	}
	
	/**
	 * 
	 * @param queryEndpoint
	 * @param patientIcns
	 * @param retrieveDocuments
	 * @throws RoutingTokenFormatException 
	 * @throws OIDFormatException 
	 * @throws ConnectionException 
	 * @throws MethodException 
	 */
	public SortedSet<DocumentSet> queryForDocumentSets(String patientIcn) 
	throws OIDFormatException, RoutingTokenFormatException, ConnectionException, MethodException
	{
		ResolvedArtifactSource resolvedArtifactSource = 
			getResolvedArtifactSource(WellKnownOID.VA_DOCUMENT.getCanonicalValue().toString(), "660");
		DocumentSetDataSourceSpi spi = getProvider().createDocumentSetDataSource(resolvedArtifactSource, "xca");
		DocumentFilter filter = new DocumentFilter(patientIcn);
		DocumentSetResult documentSetResult = spi.getPatientDocumentSets(resolvedArtifactSource.getArtifactSource().createRoutingToken(), 
				filter);
		if(documentSetResult == null)
		{
			System.out.println("\tNull returned from getPatientDocumentSets().");
			return null;
		}
		else
		{
			SortedSet<DocumentSet> documentSets = documentSetResult.getArtifacts();
			if(documentSets == null)
				System.out.println("\tNo documentSets returned in document set result.");
			else
				System.out.println("Found '" + (documentSets == null ? "<null>" : Integer.toString(documentSets.size())) + "' document sets");
			
			return documentSets;
		}
	}
	
	/**
	 * 
	 * @param documentSets
	 * @throws RoutingTokenFormatException
	 * @throws ConnectionException
	 * @throws MethodException
	 */
	private void retrieveDocumentsFromDocumentSets(SortedSet<DocumentSet> documentSets) 
	throws RoutingTokenFormatException, ConnectionException, MethodException
	{
		for(DocumentSet documentSet : documentSets)
		{
			System.out.println("\tFound '" + (documentSet == null ? "<null>" : Integer.toString(documentSet.size())) + "' documents in set.");
			assert(documentSet != null);
			retrieveDocumentsFromDocumentSet(documentSet);
		}
	}
	
	private void retrieveDocumentsFromDocumentSet(DocumentSet documentSet) 
	throws RoutingTokenFormatException, ConnectionException, MethodException
	{
		OID homeCommunityId = documentSet.getHomeCommunityId();
		for(Document document : documentSet)
		{
			System.out.println("\t\tDocument '" + document.getName() + "', " + document.getGlobalArtifactIdentifier());
			retrieveDocument(document.getGlobalArtifactIdentifier());
		}
	}

	/**
	 * @param globalArtifactIdentifier
	 * @throws RoutingTokenFormatException 
	 * @throws ConnectionException 
	 * @throws MethodException 
	 */
	private void retrieveDocument(GlobalArtifactIdentifier globalArtifactIdentifier) 
	throws RoutingTokenFormatException, ConnectionException, MethodException
	{
		ResolvedArtifactSource resolvedArtifactSource = getResolvedArtifactSource(
			RoutingTokenImpl.create(
				globalArtifactIdentifier.getHomeCommunityId(),
				globalArtifactIdentifier.getRepositoryUniqueId()
			)
		);
		
		if(resolvedArtifactSource != null)
		{
			DocumentDataSourceSpi spi = getProvider().createDocumentDataSource(resolvedArtifactSource, "xca");
			ImageStreamResponse  isr = spi.getDocument(globalArtifactIdentifier);
			assert(isr != null);
			readAndDumpImageStream(isr);
		}
	}

	/**
	 * @param isr
	 */
	private void readAndDumpImageStream(ImageStreamResponse isr)
	{
		DataSourceImageInputStream inStream = isr.getImageStream();
		assert( inStream.isReadable() );
		OutputStream bitBucket = new NullOutputStream();
		ByteStreamPump pump = ByteStreamPump.getByteStreamPump();
		try
		{
			System.out.println("There are " + inStream.getInputStream().available() + " available bytes to start.");
			int bytesTransferred = pump.xfer(inStream.getInputStream(), bitBucket);
			System.out.println("Sucessfully read " + bytesTransferred + " bytes.");
		}
		catch (IllegalArgumentException x)
		{
			x.printStackTrace();
		}
		catch (IOException x)
		{
			x.printStackTrace();
		}
	}

}
