/**
 * 
 */
package gov.va.med.imaging.ihe.xca.datasource.interactive.commands;

import java.net.URL;
import gov.va.med.OID;
import gov.va.med.WellKnownOID;
import gov.va.med.imaging.ihe.xca.datasource.configuration.XCADataSourceConfiguration;
import gov.va.med.imaging.ihe.xca.datasource.configuration.XCASiteConfiguration;
import gov.va.med.interactive.Command;
import gov.va.med.interactive.CommandParametersDescription;
import gov.va.med.interactive.CommandProcessor;

/**
 * @author vhaiswbeckec
 *
 */
public class TruststoreCommand
extends Command<XCADataSourceConfiguration>
{
	private static final CommandParametersDescription<?>[] commandParametersDescription = 
		new CommandParametersDescription[]
		{
			new CommandParametersDescription<String>("url", String.class, true), 
			new CommandParametersDescription<String>("password", String.class, true), 
		};
	public static CommandParametersDescription<?>[] getCommandParametersDescription()
	{
		return commandParametersDescription;
	}
	
	/**
	 * 
	 */
	public TruststoreCommand()
	{
		super();
	}

	/**
	 * @param commandParameterValues
	 */
	public TruststoreCommand(String[] commandParameterValues)
	{
		super(commandParameterValues);
	}

	@Override
	public void processCommand(CommandProcessor<XCADataSourceConfiguration> processor, XCADataSourceConfiguration config) 
	throws Exception
	{
		String[] commandParameters = getCommandParameterValues();

		this.validateParameters(commandParameters);
		
		config.setTruststoreUrl(commandParameters[0]);
		config.setTruststorePassword(commandParameters[1]);
	}
}
