/**
 * 
 */
package gov.va.med.imaging.ihe.xca.datasource.interactive.commands;

import gov.va.med.imaging.ihe.xca.datasource.configuration.XCADataSourceConfiguration;
import gov.va.med.interactive.Command;
import gov.va.med.interactive.CommandParametersDescription;
import gov.va.med.interactive.CommandProcessor;

/**
 * @author vhaiswbeckec
 *
 */
public class TlsCommand
extends Command<XCADataSourceConfiguration>
{
	private static final CommandParametersDescription<?>[] commandParametersDescription = 
		new CommandParametersDescription[]
		{
			new CommandParametersDescription<String>("protocol", String.class, true), 
			new CommandParametersDescription<Integer>("port", Integer.class, true), 
		};
	public static CommandParametersDescription<?>[] getCommandParametersDescription()
	{
		return commandParametersDescription;
	}
	
	/**
	 * 
	 */
	public TlsCommand()
	{
		super();
	}

	/**
	 * @param commandParameterValues
	 */
	public TlsCommand(String[] commandParameterValues)
	{
		super(commandParameterValues);
	}

	@Override
	public void processCommand(CommandProcessor<XCADataSourceConfiguration> processor, XCADataSourceConfiguration config) 
	throws Exception
	{
		String[] commandParameters = getCommandParameterValues();

		this.validateParameters(commandParameters);
		
		config.setTLSProtocol(commandParameters[0]);
		config.setTLSPort( Integer.parseInt(commandParameters[1]) );
	}
}
