package gov.va.med.imaging.ihe.xca.datasource.configuration;

import java.util.Comparator;

/**
 * A comparator that implements sorting:
 * 1.) by home community ID
 * 2.) by repository ID, where a repository ID='*' is sorted last
 * 
 * @author DNS
 */
public class XCASiteConfigurationComparator
implements Comparator<XCASiteConfiguration>
{
	/**
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(XCASiteConfiguration subject, XCASiteConfiguration object)
	{
		return subject.getRoutingToken().compareTo(object.getRoutingToken());
	}
	
}