/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 23, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.datasource;

import gov.va.med.RoutingToken;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.datasource.AbstractVersionableDataSource;
import gov.va.med.imaging.datasource.DocumentSetDataSourceSpi;
import gov.va.med.imaging.exchange.business.DocumentFilter;
import gov.va.med.imaging.exchange.business.documents.DocumentSetResult;
import gov.va.med.imaging.ihe.xca.datasource.configuration.XCADataSourceConfiguration;
import gov.va.med.imaging.ihe.xca.datasource.configuration.XCASiteConfiguration;
import gov.va.med.imaging.ihe.xca.proxy.XCADataSourceProxy;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;

/**
 * @author DNS
 *
 */
public class XCADocumentSetDataSourceService
extends AbstractVersionableDataSource
implements DocumentSetDataSourceSpi 
{
	private final static Logger logger = Logger.getLogger(XCADocumentDataSourceService.class);
	public final static String SUPPORTED_PROTOCOL = "xca";

	/**
	 * @param resolvedArtifactSource
	 * @param protocol
	 */
	public XCADocumentSetDataSourceService(ResolvedArtifactSource resolvedArtifactSource, String protocol)
	{
		super(resolvedArtifactSource, protocol);
	}

	@Override
	protected XCADataSourceConfiguration getConfiguration()
	{
		return (XCADataSourceConfiguration)super.getConfiguration();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.DocumentSetDataSource#getPatientDocumentSets(java.lang.String, gov.va.med.imaging.exchange.business.DocumentFilter)
	 */
	@Override
	public DocumentSetResult getPatientDocumentSets(RoutingToken globalRoutingToken, DocumentFilter filter) 
	throws MethodException, ConnectionException 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setDataSourceVersion("1");
		transactionContext.setDataSourceMethod("getDocumentSets");
		logger.info("getPatientDocumentSets('" + filter.getPatientId() + "') made by " + transactionContext.getDisplayIdentity());

		ResolvedArtifactSource fixedUpResolvedArtifactSource = null;
		if(getConfiguration() != null)
		{
			XCASiteConfiguration siteConfiguration = getConfiguration().findSiteConfiguration(getResolvedArtifactSource());
			try
			{
				fixedUpResolvedArtifactSource = getConfiguration().fixupURLPaths( getResolvedArtifactSource(), siteConfiguration );
			}
			catch (MalformedURLException x)
			{
				String message = 
					"Unable to fix up URL paths for resolved artifact source '" + getResolvedArtifactSource().toString() + 
					"' using configuration '" + siteConfiguration.toString() + "'.";
				logger.error(message, x);
				throw new MethodException(message, x);
			}
		}
		else
		{
			fixedUpResolvedArtifactSource = getResolvedArtifactSource();
			logger.warn("No XCA Data Source Configuration is set, no fix-up of application path or file is being applied.");
		}
		XCADataSourceProxy proxy = new XCADataSourceProxy(fixedUpResolvedArtifactSource, getConfiguration());
		
		DocumentSetResult result = proxy.getPatientDocumentSets(filter);
		logger.info("Done with getPatientDocumentSets(), returning " + (result == null ? "0" : result.getArtifactSize()) + " document sets");
		return result;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.DocumentSetDataSource#isVersionCompatible()
	 */
	@Override
	public boolean isVersionCompatible() 
	{
		return true;
	}	
}
