/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 23, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.datasource;

import gov.va.med.ProtocolHandlerUtility;
import gov.va.med.imaging.datasource.*;
import gov.va.med.imaging.ihe.xca.datasource.configuration.XCADataSourceConfiguration;
import gov.va.med.imaging.ihe.xca.datasource.interactive.XCADatasourceConfigurationCommandFactory;
import gov.va.med.imaging.ihe.xca.proxy.XCADataSourceProxy;
import gov.va.med.imaging.ihe.xca.proxy.XCAProxyUtilities;
import gov.va.med.interactive.CommandController;
import gov.va.med.interactive.CommandFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author DNS
 *
 */
public class XCADataSourceProvider
extends Provider
{

	private static final long serialVersionUID = -2475090374494375682L;
	
	public static final String PROVIDER_NAME = "XCADataSource";
	public static final double PROVIDER_VERSION = 1.0d;
	private static final String PROVIDER_INFO = 
		"Implements: \n" + 
		"DocumentSetDataSource, DocumentDataSource SPI \n" + 
		"as an XCA Initiating Gateway.";
	
	private final static Logger logger = Logger.getLogger(XCADataSourceProvider.class);

	// ========================================================================================
	//
	// ========================================================================================
	
	private ProviderConfiguration<XCADataSourceConfiguration> providerConfiguration = null;
	private XCADataSourceConfiguration configuration = null;
	private final SortedSet<ProviderService> services;
	
	public XCADataSourceProvider()
	{
		this(PROVIDER_NAME, PROVIDER_VERSION, PROVIDER_INFO);
	}

	/**
	 * 
	 * @param name
	 * @param version
	 * @param info
	 */
	private XCADataSourceProvider(String name, double version, String info)
	{
		super(name, version, info);
		services = new TreeSet<ProviderService>();
		services.add(
			new ProviderService(
				this, 
				DocumentDataSourceSpi.class, 
				XCADocumentDataSourceService.SUPPORTED_PROTOCOL, 
				1.0F, 
				XCADocumentDataSourceService.class)
		);
		services.add(
			new ProviderService(
				this, 
				DocumentSetDataSourceSpi.class, 
				XCADocumentSetDataSourceService.SUPPORTED_PROTOCOL, 
				1.0F, 
				XCADocumentSetDataSourceService.class)
		);
		
		this.providerConfiguration = new ProviderConfiguration<XCADataSourceConfiguration>(name, version);
		
		try
		{
			setConfiguration( providerConfiguration.loadConfiguration() );
			if(getInstanceConfiguration() != null)
				logger.info("XCADataSourceProvider configuration successfully loaded.");
			else
				logger.info("XCADataSourceProvider configuration not loaded.");
		}
		catch (IOException x)
		{
			logger.warn("XCADataSourceProvider configuration NOT loaded.", x);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.Provider#getServices()
	 */
	@Override
	public SortedSet<ProviderService> getServices() 
	{
		return services;
	}
	
	public ProviderConfiguration<XCADataSourceConfiguration> getProviderConfiguration()
	{
		return this.providerConfiguration;
	}

	@Override
	public void storeConfiguration()
    {
		try
		{
			getProviderConfiguration().store(getInstanceConfiguration());
		}
		catch (IOException x)
		{
			logger.error(x);
		}
    }
	
	/**
	 * A package level method for SPI implementation to get the
	 * Configuration.
	 * 
	 * @return
	 */
	@Override
	protected XCADataSourceConfiguration getInstanceConfiguration()
	{
		return configuration;
	}
	void setConfiguration(XCADataSourceConfiguration config)
	{
		this.configuration = config;
	}
	
	/**
	 * 
	 * @param args
	 */
	public static void main(String[] argv)
	{
		Logger.getRootLogger().setLevel(Level.ALL);
		ProtocolHandlerUtility.initialize(true);
		
		XCADataSourceProvider provider = new XCADataSourceProvider();
		try
		{
			CommandFactory<XCADataSourceConfiguration> factory = 
				new XCADatasourceConfigurationCommandFactory(provider);
			XCADataSourceConfiguration config = provider.getInstanceConfiguration();
			if(config == null)
			{
				logger.warn("Unable to load configuration, creating default (blank) configuration.");
				config = XCADataSourceConfiguration.create();
				provider.setConfiguration(config);
			}
			
			gov.va.med.interactive.CommandController<XCADataSourceConfiguration> commandController = 
				new CommandController<XCADataSourceConfiguration>(
					config, 
					factory,
					argv
				);
			commandController.getCommandSource().pushCommands(argv);
			commandController.run();
		}
		catch (Exception x)
		{
			x.printStackTrace();
		}
	}
}
