/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.vixserverhealth;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class VixServerHealthRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public VixServerHealthRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getVixServerHealth(
 			gov.va.med.imaging.health.VixServerHealthSource[] vixServerHealthSources
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVixServerHealthCommand' and parameters 'gov.va.med.imaging.health.VixServerHealthSource[]'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.health.VixServerHealth.class, 
	 				"GetVixServerHealthCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.health.VixServerHealthSource[].class 
		  			},
 					new Object[]{
				 		vixServerHealthSources
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetVixServerHealthCommand' in method 'getVixServerHealth' with parameters 'gov.va.med.imaging.health.VixServerHealthSource[]'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getVixSiteServerHealth(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.Boolean forceRefresh
 		 			, gov.va.med.imaging.health.VixServerHealthSource[] vixServerHealthSources
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVixSiteServerHealthBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, java.lang.Boolean, gov.va.med.imaging.health.VixServerHealthSource[]'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.health.VixSiteServerHealth.class, 
	 				"GetVixSiteServerHealthBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.Boolean.class, gov.va.med.imaging.health.VixServerHealthSource[].class 
		  			},
 					new Object[]{
				 		routingToken,forceRefresh,vixServerHealthSources
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetVixSiteServerHealthBySiteNumberCommand' in method 'getVixSiteServerHealth' with parameters 'gov.va.med.RoutingToken, java.lang.Boolean, gov.va.med.imaging.health.VixServerHealthSource[]'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getVixSiteServerHealthList(
 			java.lang.Boolean forceRefresh
 		 			, gov.va.med.imaging.health.VixServerHealthSource[] vixServerHealthSources
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVixSiteServerHealthListCommand' and parameters 'java.lang.Boolean, gov.va.med.imaging.health.VixServerHealthSource[]'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.health.VixSiteServerHealth.class, 
 				"GetVixSiteServerHealthListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.Boolean.class, gov.va.med.imaging.health.VixServerHealthSource[].class 
	  			},
				new Object[]{
			 		forceRefresh,vixServerHealthSources
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetVixSiteServerHealthListCommand' in method 'getVixSiteServerHealthList' with parameters 'java.lang.Boolean, gov.va.med.imaging.health.VixServerHealthSource[]'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getVixSiteServerHealthListByRegion(
 			java.lang.String regionNumber
 		 			, java.lang.Boolean forceRefresh
 		 			, gov.va.med.imaging.health.VixServerHealthSource[] vixServerHealthSources
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVixSiteServerHealthListByRegionCommand' and parameters 'java.lang.String, java.lang.Boolean, gov.va.med.imaging.health.VixServerHealthSource[]'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.health.VixSiteServerHealth.class, 
 				"GetVixSiteServerHealthListByRegionCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.Boolean.class, gov.va.med.imaging.health.VixServerHealthSource[].class 
	  			},
				new Object[]{
			 		regionNumber,forceRefresh,vixServerHealthSources
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetVixSiteServerHealthListByRegionCommand' in method 'getVixSiteServerHealthListByRegion' with parameters 'java.lang.String, java.lang.Boolean, gov.va.med.imaging.health.VixServerHealthSource[]'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getRegion(
 			java.lang.String regionId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetRegionCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Region.class, 
	 				"GetRegionCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		regionId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetRegionCommand' in method 'getRegion' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getLocalSiteVixSiteServerHealth(
 			gov.va.med.imaging.health.VixServerHealthSource[] vixServerHealthSources
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetLocalSiteVixSiteServerHealthCommand' and parameters 'gov.va.med.imaging.health.VixServerHealthSource[]'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.health.VixSiteServerHealth.class, 
	 				"GetLocalSiteVixSiteServerHealthCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.health.VixServerHealthSource[].class 
		  			},
 					new Object[]{
				 		vixServerHealthSources
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetLocalSiteVixSiteServerHealthCommand' in method 'getLocalSiteVixSiteServerHealth' with parameters 'gov.va.med.imaging.health.VixServerHealthSource[]'.");
 		}

 }