/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * @date Dec 31, 2010
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */

package gov.va.med.imaging.exchange.business.taglib;

import gov.va.med.WellKnownOID;

/**
 * @author DNS
 *
 */
public class WellKnownOIDIterator
{
	private WellKnownOID[] oids;
	private int currentIndex;
	private String selectedOidValue = null;
	
	public WellKnownOIDIterator()
	{
		// explicitly declared no-arg constructor to emphasize requirement
		// that it be present.
		oids = WellKnownOID.values();
		currentIndex = 0;
	}
	
	public void setSelected(String selectedOidValue)
	{
		this.selectedOidValue = selectedOidValue;
	}
	
	public WellKnownOID current()
	throws IllegalStateException
	{
		if(currentIndex < oids.length)
			return oids[currentIndex];
		throw new IllegalStateException("Attempt to read past end of iterator.");
	}

	public boolean isCurrentSelected()
	{
		return current().isApplicable(this.selectedOidValue);
	}
	
	public void next()
	{
		++currentIndex;
	}
	
	public boolean hasNext()
	{
		return(currentIndex < oids.length-1);
	}
}
