/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.exchange;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class VixGuiWebAppRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public VixGuiWebAppRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void refreshSiteServiceCache(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessSiteServiceCacheRefreshCommand' and parameters ''.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"ProcessSiteServiceCacheRefreshCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessSiteServiceCacheRefreshCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntries(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.lang.String fieldName
 		 			, java.lang.String fieldValue
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTransactionLogEntriesCommand' and parameters 'gov.va.med.imaging.access.TransactionLogWriter, java.lang.String, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,fieldName,fieldValue
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetTransactionLogEntriesCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntries(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.util.Date startDate
 		 			, java.util.Date endDate
 		 			, gov.va.med.imaging.exchange.enums.ImageQuality imageQuality
 		 			, java.lang.String user
 		 			, java.lang.String modality
 		 			, gov.va.med.imaging.exchange.enums.DatasourceProtocol datasourceProtocol
 		 			, java.lang.String errorMessage
 		 			, java.lang.String imageUrn
 		 			, java.lang.String transactionId
 		 			, java.lang.Boolean forward
 		 			, java.lang.Integer startIndex
 		 			, java.lang.Integer endIndex
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTransactionLogEntriesCommand' and parameters 'gov.va.med.imaging.access.TransactionLogWriter, java.util.Date, java.util.Date, gov.va.med.imaging.exchange.enums.ImageQuality, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.enums.DatasourceProtocol, java.lang.String, java.lang.String, java.lang.String, java.lang.Boolean, java.lang.Integer, java.lang.Integer'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.util.Date.class, java.util.Date.class, gov.va.med.imaging.exchange.enums.ImageQuality.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.enums.DatasourceProtocol.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Integer.class, java.lang.Integer.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,startDate,endDate,imageQuality,user,modality,datasourceProtocol,errorMessage,imageUrn,transactionId,forward,startIndex,endIndex
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetTransactionLogEntriesCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getJavaLogFiles(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetJavaLogListCommand' and parameters ''.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.javalogs.JavaLogFile.class, 
 				"GetJavaLogListCommand",
 				"",
				new Class<?>[]{
				 	 
	  			},
				new Object[]{
			 		
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetJavaLogListCommand' in method 'getJavaLogFiles' with parameters ''.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getJavaLogFile(
 			java.lang.String filename
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetJavaLogFileCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.io.InputStream.class, 
	 				"GetJavaLogFileCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		filename
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetJavaLogFileCommand' in method 'getJavaLogFile' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntriesByTransactionId(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.lang.String transactionId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTransactionLogEntriesByTransactionIdCommand' and parameters 'gov.va.med.imaging.access.TransactionLogWriter, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesByTransactionIdCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,transactionId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetTransactionLogEntriesByTransactionIdCommand'.");		  		
 		}

 }