/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.exchange;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class VixGuiWebAppRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements VixGuiWebAppRouter
 {
	private static VixGuiWebAppRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized VixGuiWebAppRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new VixGuiWebAppRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected VixGuiWebAppRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void refreshSiteServiceCache(
 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"ProcessSiteServiceCacheRefreshCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessSiteServiceCacheRefreshCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntries(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.lang.String fieldName
 		 			, java.lang.String fieldValue
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,fieldName,fieldValue
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetTransactionLogEntriesCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntries(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.util.Date startDate
 		 			, java.util.Date endDate
 		 			, gov.va.med.imaging.exchange.enums.ImageQuality imageQuality
 		 			, java.lang.String user
 		 			, java.lang.String modality
 		 			, gov.va.med.imaging.exchange.enums.DatasourceProtocol datasourceProtocol
 		 			, java.lang.String errorMessage
 		 			, java.lang.String imageUrn
 		 			, java.lang.String transactionId
 		 			, java.lang.Boolean forward
 		 			, java.lang.Integer startIndex
 		 			, java.lang.Integer endIndex
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.util.Date.class, java.util.Date.class, gov.va.med.imaging.exchange.enums.ImageQuality.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.enums.DatasourceProtocol.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Integer.class, java.lang.Integer.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,startDate,endDate,imageQuality,user,modality,datasourceProtocol,errorMessage,imageUrn,transactionId,forward,startIndex,endIndex
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetTransactionLogEntriesCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.javalogs.JavaLogFile> getJavaLogFiles(
 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.javalogs.JavaLogFile.class, 
 				"GetJavaLogListCommand",
 				"",
				new Class<?>[]{
				 	 
	  			},
				new Object[]{
			 		
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetJavaLogListCommand");
		
      
			java.util.List<gov.va.med.imaging.javalogs.JavaLogFile> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.io.InputStream getJavaLogFile(
 			java.lang.String filename
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.io.InputStream> command = (Command<java.io.InputStream>)getCommandFactory().createCommand(
	 				 java.io.InputStream.class, 
	 				"GetJavaLogFileCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		filename
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetJavaLogFileCommand");
		
      
        java.io.InputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntriesByTransactionId(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.lang.String transactionId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesByTransactionIdCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,transactionId
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetTransactionLogEntriesByTransactionIdCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 }