<%@ page 
	language="java" 
	import="java.util.*, java.text.*" 
	pageEncoding="ISO-8859-1" 
	session="false" 
	contentType="text/html; charset=ISO-8859-1"%>
<%@ taglib uri="http://DNS.URL       /vix/menu" prefix="menu"%>

<% 
	DateFormat dfDateOnly = new SimpleDateFormat("MM/dd/yyyy");
	
	String contextPath = request.getContextPath();
	String servletPath = request.getServletPath();
	String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+contextPath;
	
	Date fromDate = gov.va.med.imaging.DateUtil.currentDayStart();
	String fromDateParam = request.getParameter("fromDate");
	if(fromDateParam != null)
		fromDate = dfDateOnly.parse( fromDateParam );
	fromDate = gov.va.med.imaging.DateUtil.dayStart(fromDate);
	fromDateParam =dfDateOnly.format(fromDate);
		
	Date toDate = gov.va.med.imaging.DateUtil.currentDayEnd();
	String toDateParam = request.getParameter("toDate");
	if(toDateParam != null)
		toDate = dfDateOnly.parse( toDateParam );
	toDate = gov.va.med.imaging.DateUtil.dayEnd(toDate);
	toDateParam = dfDateOnly.format(toDate);
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<style type="text/css" media="screen">
		@import url("style/screen.css");
		</style>
		   
		<title>Vista Imaging Web Access</title>
		   
		<meta http-equiv="pragma" content="no-cache">
		<meta http-equiv="cache-control" content="no-cache">
		<meta http-equiv="expires" content="0">    
		<meta http-equiv="keywords" content="Vista VIX Imaging">
		<meta http-equiv="description" content="VistA Imaging Web Access">
		
		<title>VIX - Transaction Log</title>
		<script type="text/javascript" src="script/browser.js">
		</script>
		<script type="text/javascript" src="script/calendar.js">
		</script>
		<script type="text/javascript" src="script/menu-for-applications.js">
		</script>
		<script type="text/javascript" src="script/vix.js">
		</script>
	</head>

	<body onload="load();" id="vix">
		<div id="pageHeader">
			<h1><span>VIX</span></h1>
		</div>
		<!-- The main menu is generated by a tag lib so that unreachable items are not displayed -->
		<menu:Menu 
			menuId="menuModel" 
			menuClass="menu" 
			subMenuClass="mainMenuSubMenu" 
			menuItemClass="mainMenuItem"
			menuDivId="menuDiv" />
		
		<div id="container">
			<div id="selection">
				<h1>Selection Header</h1>
				<ol>
					<li>Selection Item 1</li>
					<li>Selection Item 2</li>
					<li>
					    Date Range:<br/>
						<span id="fromDateContainer">
							<input type="text" id="fromDate" name="fromDate" 
								value=<%="\"" + fromDateParam + "\""%> 
								maxlength="10" width="100px" 
								title="cssbody=[dvbdy1] cssheader=[dvhdr1] header=[Start Date] body=[Include transactions from this date to the end date.]"
							/>
							&nbsp;
							<img class="button-img" src="images/Calendar.png" onclick="fromDatePicker.show();" />
						</span> 
					    <br/>-to-<br/>
						<span id="toDateContainer">
							<input type="text" id="toDate" name="toDate" 
								value=<%="\"" + toDateParam + "\""%> 
								maxlength="10" width="100px" 
								title="cssbody=[dvbdy1] cssheader=[dvhdr1] header=[End Date] body=[Include transactions from the start date to this date.]"
							/>
							&nbsp;
							<img class="button-img" src="images/Calendar.png" onclick="toDatePicker.show();" />
						</span>
					</li>
				</ol>
			</div>
			<div id="supportingText">
				<h1>Supporting Text Title</h1>
				<p>
				This is a template page, copy this to get the basic formatting of a
				Vix GUI page.
				</p>
			</div>
		</div>
		<div id="pageFooter">
			<jsp:include flush="true" page="footer.html" />
		</div>		
	</body>
</html>