<%@ page 
language="java" 
import="java.util.*, java.text.*, gov.va.med.imaging.*, gov.va.med.imaging.exchange.enums.*" 
pageEncoding="ISO-8859-1"%>
<%@page import="gov.va.med.imaging.transactioncontext.TransactionContext"%>
<%@page import="gov.va.med.imaging.transactioncontext.TransactionContextFactory"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://DNS.URL       /vix/business" prefix="business"%>
<%@ taglib uri="http://DNS.URL       /vix/transactionlogs" prefix="log"%>
<%@ taglib uri="http://DNS.URL       /vix/menu" prefix="menu"%>

<jsp:directive.page session="false" contentType="text/html" />

<% 
	DateFormat dfDateOnly = new SimpleDateFormat("MM/dd/yyyy");
	
	
	String contextPath = request.getContextPath();
	String servletPath = request.getServletPath();
	String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+contextPath;
	
	Date fromDate = gov.va.med.imaging.DateUtil.currentDayStart();
	String resetStartDate = dfDateOnly.format(fromDate);
	String fromDateParam = request.getParameter("fromDate");
	if(fromDateParam != null)
		fromDate = dfDateOnly.parse( fromDateParam );
	fromDate = gov.va.med.imaging.DateUtil.dayStart(fromDate);
	fromDateParam =dfDateOnly.format(fromDate);
		
	Date toDate = gov.va.med.imaging.DateUtil.currentDayEnd();
	String resetEndDate = dfDateOnly.format(toDate);
	String toDateParam = request.getParameter("toDate");
	if(toDateParam != null)
		toDate = dfDateOnly.parse( toDateParam );
	toDate = gov.va.med.imaging.DateUtil.dayEnd(toDate);
	toDateParam = dfDateOnly.format(toDate);
		
	String imageQualityParam = request.getParameter("imageQuality");
	ImageQuality imageQuality = null;
	if(imageQualityParam != null)
	{
		try{imageQuality = ImageQuality.valueOf(imageQualityParam);}
		catch(IllegalArgumentException iaX){imageQuality = null;}
	}
	String user = request.getParameter("user");
	String modality = request.getParameter("modality");
	
	String datasourceProtocolParam = request.getParameter("datasourceProtocol");
	DatasourceProtocol datasourceProtocol = null;
	if(datasourceProtocolParam != null)
	{
		try{ datasourceProtocol = DatasourceProtocol.valueOf(datasourceProtocolParam); }
		catch(IllegalArgumentException iaX){datasourceProtocol = null;}
	}
	
	String errorMessage = request.getParameter("errorMessage");
	String transactionId = request.getParameter("transactionId");
	String imageUrn = request.getParameter("imageUrn");
	
	String forwardIterationParam = request.getParameter("forwardIteration");
	Boolean forwardIteration = Boolean.FALSE;
	if( forwardIterationParam != null )
		forwardIteration = Boolean.parseBoolean(forwardIterationParam);
	
	String startIndexParam = request.getParameter("startIndex");
	int startIndex = 0;
	if(startIndexParam != null)
		startIndex = Integer.parseInt(startIndexParam);
		
	// DKB
	if (startIndex < 0) startIndex = 0;
		
	String resultsPerPageParam = request.getParameter("resultsPerPage");
	Integer requestResultsPerPage = new Integer(100);
	if(resultsPerPageParam != null)
		requestResultsPerPage = new Integer(resultsPerPageParam);
		
	int endIndex = startIndex + requestResultsPerPage;

	String byteTransferPathParam = request.getParameter ("byteTransferPath");
	ByteTransferPath byteTransferPath = null;
	if(byteTransferPathParam != null)
	{
		try{ byteTransferPath = ByteTransferPath.valueOf(byteTransferPathParam); }
		catch(IllegalArgumentException iaX){byteTransferPath = null;}
	}
	else
	{
		byteTransferPath = ByteTransferPath.DS_IN_FACADE_OUT;
	}
	
	boolean debug = false;
	String debugValue = request.getParameter("debug");
	if((debugValue != null) && (debugValue.length() > 0))
	{
		debug = Boolean.parseBoolean(debugValue);
	}
	
	TransactionContext transactionContext = TransactionContextFactory.get();
%>

<html>
	<!-- 
	Notes from the JSP Spec (syntax examples have added whitespace to prevent recognition as
	directives or elements).
	
	A JSP page has elements and template data. An element is an instance of an element
	type known to the JSP container. Template data is everything else; that is, anything
	that the JSP translator does not know about.
	There are three types of elements: directive elements, scripting elements, and
	action elements.
	Directives "< %@ directive...%>" provide global information that is conceptually valid independent
	of any specific request received by the JSP page. They provide information for
	the translation phase.
	Action elements follow the syntax of an XML element.  Actions provide information for the request 
	processing phase.  An action may create objects and may make them available to the scripting elements 
	through scripting-specific variables.
	Scripting Elements EL expressions use the syntax ${expr}.  JSP 2.0 retains the three language-based 
	types of scripting elements: declarations, scriptlets, and expressions. 
	Declarations follow the syntax < %! ... %>.
	Scriptlets follow the syntax < % ... %>. 
	Expressions follow the syntax < %= ... %>.
	
	A context-relative path is a path that starts with a slash (/). It is to be interpreted
	as relative to the application to which the JSP page or tag file belongs.
	A page relative path is a path that does not start with a slash (/). It is to be interpreted
	as relative to the current JSP page, or the current JSP file or tag file, depending on where the path is being used.
	
	A JSP Document is a JSP page that is also an XML document. When a JSP document is encountered by
	the JSP container, it is interpreted as an XML document first and after that as a JSP page.
	-->

	<head>
		<meta http-equiv="pragma" content="no-cache"/>
		<meta http-equiv="cache-control" content="no-cache"/>
		<meta http-equiv="expires" content="0"/>    
		<meta http-equiv="keywords" content="Vista VIX Imaging Transaction"/>
		<meta http-equiv="description" content="VistA Imaging Web Access Transaction"/>
				 
		<style type="text/css" title="currentStyle">
			@import url(../style/screen1.css);
		</style>
		<!-- addition below for a custom css for IE 7-8, and text-printing in FireFox 3.x  7/31/09 --> 
		<link rel="stylesheet" type="text/css" media="print" href="../style/printer_friendly1.css" />
		<!--[if gte IE 7]>
		       <style type="text/css" title="currentStyle">
			   @import url(../style/screenie1.css);
			   </style>
		<![endif]-->
		<!--for print preview in IE 7-8 (minimum)-->
		<!--[if gte IE 7]>
			   <link rel="stylesheet" type="text/css" media="print" href="../style/printerie1.css" />
		<![endif]--> 
		<title>Vix - Transaction Log (<%= transactionContext.getRealm() %>)</title>
		<script type="text/javascript" src="../script/browser.js">
		</script>
		
	<script language = "Javascript">
	/**
	 * DHTML date validation script. Courtesy of SmartWebby.com (http://www.smartwebby.com/dhtml/)
	 * Enhanced 1-20-2010 to check date range and to avoid pop-up windows.
	 */
	// Declaring valid date character, minimum year and maximum year
	var dtCh= "/";
	var minYear=1900;
	var maxYear=2100;
	function isInteger(s){
		var i;
		for (i = 0; i < s.length; i++){   
			// Check that current character is number.
			var c = s.charAt(i);
			if (((c < "0") || (c > "9"))) return false;
		}
		// All characters are numbers.
		return true;
	}

	function stripCharsInBag(s, bag){
		var i;
		var returnString = "";
		// Search through string's characters one by one.
		// If character is not in bag, append to returnString.
		for (i = 0; i < s.length; i++){   
			var c = s.charAt(i);
			if (bag.indexOf(c) == -1) returnString += c;
		}
		return returnString;
	}

	function daysInFebruary (year){
		// February has 29 days in any year evenly divisible by four,
		// EXCEPT for centurial years which are not also divisible by 400.
		return (((year % 4 == 0) && ( (!(year % 100 == 0)) || (year % 400 == 0))) ? 29 : 28 );
	}
	function DaysArray(n) {
		for (var i = 1; i <= n; i++) {
			this[i] = 31
			if (i==4 || i==6 || i==9 || i==11) {this[i] = 30}
			if (i==2) {this[i] = 29}
	   } 
	   return this
	}

	function isDate(dtStr){
		//document.all.errorLabel.childNodes[0].nodeValue = "&nbsp"
		var daysInMonth = DaysArray(12)
		var pos1=dtStr.indexOf(dtCh)
		var pos2=dtStr.indexOf(dtCh,pos1+1)
		var strMonth=dtStr.substring(0,pos1)
		var strDay=dtStr.substring(pos1+1,pos2)
		var strYear=dtStr.substring(pos2+1)
		strYr=strYear
		if (strDay.charAt(0)=="0" && strDay.length>1) strDay=strDay.substring(1)
		if (strMonth.charAt(0)=="0" && strMonth.length>1) strMonth=strMonth.substring(1)
		for (var i = 1; i <= 3; i++) {
			if (strYr.charAt(0)=="0" && strYr.length>1) strYr=strYr.substring(1)
		}
		month=parseInt(strMonth)
		day=parseInt(strDay)
		year=parseInt(strYr)
		if (pos1==-1 || pos2==-1){
			//document.all.errorLabel.childNodes[0].nodeValue = "The date format should be : mm/dd/yyyy"
			alert("The date format should be : mm/dd/yyyy")
			return false
		}
		if (strMonth.length<1 || month<1 || month>12){
			//document.all.errorLabel.childNodes[0].nodeValue = "Please enter a valid month"
			alert("Please enter a valid month")
			return false
		}
		if (strDay.length<1 || day<1 || day>31 || (month==2 && day>daysInFebruary(year)) || day > daysInMonth[month]){
			//document.all.errorLabel.childNodes[0].nodeValue = "Please enter a valid day"
			alert("Please enter a valid day")
			return false
		}
		if (strYear.length != 4 || year==0 || year<minYear || year>maxYear){
			//document.all.errorLabel.childNodes[0].nodeValue = "Please enter a valid 4 digit year between "+minYear+" and "+maxYear
			alert("Please enter a valid 4 digit year between "+minYear+" and "+maxYear)
			return false
		}
		if (dtStr.indexOf(dtCh,pos2+1)!=-1 || isInteger(stripCharsInBag(dtStr, dtCh))==false){
			//document.all.errorLabel.childNodes[0].nodeValue = "Please enter a valid date"
			alert("Please enter a valid date")
			return false
		}
	return true
	}
	</script>
		
		<script type="text/javascript">         
			function getCurrentPageStartIndex() {
				var startIndexElement = document.getElementById('startIndex');
				if(startIndexElement && startIndexElement.value && startIndexElement.value != '')
					return parseInt(startIndexElement.value);
				return 0;
			}
			function getCurrentPageEndIndex() {
				var endIndexElement = document.getElementById('endIndex');
				if(endIndexElement && endIndexElement.value && endIndexElement.value != '')
					return parseInt(endIndexElement.value);
				return 100;
			}
			function getSelectedResultsPerPage() {
				var resultsSelectElement = document.getElementById('resultsPerPage');
				var selectedIndex = resultsSelectElement.selectedIndex; 
				return parseInt(resultsSelectElement.options[selectedIndex].value);
			}
			// The following functions do the HTML GET requests.
			function move(startIndex, endIndex) {
				document.getElementById('transactionLogSearchCriteria').action="<%=contextPath + servletPath %>";
				document.getElementById('format').value='text/html';
				document.getElementById('startIndex').value=startIndex;
				document.getElementById('endIndex').value=endIndex;
				document.getElementById('transactionLogSearchCriteria').submit();			
			}
			function firstPage() {
				//document.all.errorLabel.childNodes[0].nodeValue = "&nbsp";											
				var fromDate = document.getElementById('fromDate');
				var toDate = document.getElementById('toDate');				
			    if (isDate(fromDate.value)==false){
					fromDate.focus()
					return false
				}
				if (isDate(toDate.value)==false){
					toDate.focus()
					return false
				}
				// flip the values if the Start Date is after the End Date
				if (Date.parse(fromDate.value) > Date.parse(toDate.value)){
					var startDateValuetemp = toDate.value;
					var endDateValuetemp = fromDate.value; 
					fromDate.value = startDateValuetemp;
					toDate.value = endDateValuetemp;
					fromDate.focus();
					return false;
				}
				else
				{
					move(0, getSelectedResultsPerPage());
				}
				
			}
			function nextPage() {
				var nextPageStartIndex = getCurrentPageEndIndex();
				var nextPageEndIndex = nextPageStartIndex + getSelectedResultsPerPage();
				move(nextPageStartIndex, nextPageEndIndex);
			}
			function previousPage() {
				var nextPageStartIndex = getCurrentPageStartIndex() - getSelectedResultsPerPage();
				var nextPageEndIndex = getCurrentPageStartIndex();
				if (nextPageStartIndex < 0) {
					nextPageStartIndex = 0;
					nextPageEndIndex = getSelectedResultsPerPage();
				}				
				move(nextPageStartIndex, nextPageEndIndex);
			}
			// Send an HTTP request for Excel, CSV and TSV formatted transaction logs
			function submitExcel(mimeType) {
			//document.all.errorLabel.childNodes[0].nodeValue = "&nbsp";
			var fromDate = document.getElementById('fromDate');
			var toDate = document.getElementById('toDate');
				//alert(fromDate.value)
			    if (isDate(fromDate.value)==false){
					fromDate.focus()
					return false
				}
				if (isDate(toDate.value)==false){
					toDate.focus()
					return false
				}
				// flip the values if the Start Date is after the End Date
				if (Date.parse(fromDate.value) > Date.parse(toDate.value)){
					var startDateValuetemp = toDate.value;
					var endDateValuetemp = fromDate.value; 
					fromDate.value = startDateValuetemp;
					toDate.value = endDateValuetemp;
					fromDate.focus();
					return false;
				}	
				else
				{
					move(0, getSelectedResultsPerPage());
				}		
			
				document.getElementById('transactionLogSearchCriteria').action='ExcelTransactionLog';
				document.getElementById('format').value=mimeType; 
				document.getElementById('transactionLogSearchCriteria').submit();			
			}
			function resetSearchCriteria() {
				document.getElementById('transactionLogSearchCriteria').reset();
				var fromDate = document.getElementById('fromDate');
				var toDate = document.getElementById('toDate');
				fromDate.value = '<%= resetStartDate %>';					
				toDate.value = '<%= resetEndDate %>';					
			}
			// Context Help Pop-up  
			var helpSubjectElement = null;
			var helpContentElement = null;

			// regexElementId - the ID of the element that is the subject of the help 
			// regexHelpElementId - the ID of the help element (the one that contains the help text) 			
			function showHelp(helpSubjectElementId, helpContentElementId)
			{
				//alert("Agent is " + browserSniffer.agt);
				helpSubjectElement = document.getElementById(helpSubjectElementId);
				helpContentElement = document.getElementById(helpContentElementId);
				
				helpContentElement.style.top = (browserSniffer.getElementTop(helpSubjectElementId) + 10) + 'px';
				helpContentElement.style.left = (browserSniffer.getElementLeft(helpSubjectElementId) + browserSniffer.getElementWidth(helpSubjectElementId) + 100) + 'px';
				//alert("helpContentElement is " + helpContentElement + "@ " + helpContentElement.style.top + ", " + helpContentElement.style.left);
				helpContentElement.style.visibility = "visible";
			}
			
			function hideHelp()
			{
				helpContentElement.style.visibility = "hidden";
				helpSubjectElement = null;
				helpContentElement = null;
			}
			
			function setHelpField(value)
			{
				helpSubjectElement.value = value;
			}
			function appendHelpField(value)
			{
				helpSubjectElement.value = helpSubjectElement.value + value;
			}
			
			// methods to change the displayed images on mouse events 
			function turnMouseOff(ImageName) {
				document.images[ImageName].src = eval(ImageName + "MouseOff.src");
			}
			
			function turnMouseDown(ImageName) {
				document.images[ImageName].src = eval(ImageName + "MouseDown.src");
			}
		</script>		 
	</head>
	<body id="vix-transaction">
		<div id="pageHeader">
			<h1><span>&nbsp;VIX - Transaction Log (<%= transactionContext.getRealm() %>)</span></h1>
		</div>
		<div id="container">
			<div id="selection">
				<h1>Transaction Log Filter</h1>
			</div>
				<form id="transactionLogSearchCriteria" action=<%= "\"" + servletPath + "\""%> method="GET">
						<!-- 
						The startIndex and endIndex elements are the indexes of the currently displayed page.
						The script that submits this form will push values into these elements immediately
						before submitting the form, which get passed as query parameters.
						The resultsPerPage query parameter is set from a select element within this form.
						The aforementioned script (that submits this form) uses the resultsPerPage
						element to calculate the requested start and end index.  Other than that the
						resultsPerPage is simply passed back and forth between browser and server so
						that it remains durable.
						-->
						<input type="hidden" id="startIndex" name="startIndex" value="${param.startIndex}" />
						<input type="hidden" id="endIndex" name="endIndex" value="${param.endIndex}" />
						<input type="hidden" id="format" name="format" value=""/>
		    			    <div id="dateInputs">
                            <table cellspacing="1" cellpadding="8" border="0" width="1200">
								<tr>
									<td width="8%"><label for="fromDate">Start Date: </label><input type="text" maxlength="10" id="fromDate" name="fromDate" tabindex="1" 
	                                    	   value=<%= fromDateParam %> style="width:100; height:25"/></td>
	                            </tr>
	                            <tr></tr>
	                            <tr>
									<td width="8%"><label for="toDate">End Date: </label><input type="text" maxlength="10" id="toDate" name="toDate" tabindex="2"  						
			                                   value=<%= toDateParam %> style="width:100; height:25"/></td>
									<td><br><br></td> 
								 </tr>	
                             </table>
                             </div>
                             <br />
							<c:set var="transactionPerPage" value="${param.resultsPerPage}"/>
							<div id="transactions">
					    	<label for="resultsPerPage">Transactions per Page:</label><br/>
							<select id="resultsPerPage" name="resultsPerPage"/>
							  <c:choose>
									<c:when test="${transactionPerPage == '25'}">
										<jsp:element name="option">
											<jsp:attribute name="value">25</jsp:attribute>
											<jsp:attribute name="selected">selected</jsp:attribute>
											<jsp:body>25</jsp:body>
										</jsp:element>
									</c:when>
									<c:otherwise>
										<jsp:element name="option">
											<jsp:attribute name="value">25</jsp:attribute>
											<jsp:body>25</jsp:body>
										</jsp:element>
									</c:otherwise>
								</c:choose>
								<c:choose>
									<c:when test="${transactionPerPage == '100' || empty param.resultsPerPage}">
										<jsp:element name="option">
											<jsp:attribute name="value">100</jsp:attribute>
											<jsp:attribute name="selected">selected</jsp:attribute>
											<jsp:body>100</jsp:body>
										</jsp:element>
									</c:when>
									<c:otherwise>
										<jsp:element name="option">
											<jsp:attribute name="value">100</jsp:attribute>
											<jsp:body>100</jsp:body>
										</jsp:element>
									</c:otherwise>
								</c:choose>
								<c:choose>
									<c:when test="${transactionPerPage == '250'}">
										<jsp:element name="option">
											<jsp:attribute name="value">250</jsp:attribute>
											<jsp:attribute name="selected">selected</jsp:attribute>
											<jsp:body>250</jsp:body>
										</jsp:element>
									</c:when>
									<c:otherwise>
										<jsp:element name="option">
											<jsp:attribute name="value">250</jsp:attribute>
											<jsp:body>250</jsp:body>
										</jsp:element>
									</c:otherwise>
								</c:choose>
								<c:choose>
									<c:when test="${transactionPerPage == '1000'}">
										<jsp:element name="option">
											<jsp:attribute name="value">1000</jsp:attribute>
											<jsp:attribute name="selected">selected</jsp:attribute>
											<jsp:body>1000</jsp:body>
										</jsp:element>
									</c:when>
									<c:otherwise>
										<jsp:element name="option">
											<jsp:attribute name="value">1000</jsp:attribute>
											<jsp:body>1000</jsp:body>
										</jsp:element>
									</c:otherwise>
								</c:choose>
							</select>
						    <br /><br /><br /><br />
                        </div>
						<div id="center">
						    <table border="0" width="700">
						    <tr>
							<td><input type="button" style="width:150;height:30;display:inline" value="Show in Browser" onclick="firstPage();" alt="ShowInBrowser"/></td>	 
							<td><input type="button" style="width:150;height:30;display:inline" value="Save as CSV" onclick="submitExcel('text/csv');" alt="SaveAsCSV"/></td>	
							<td><input type="button" style="width:150;height:30;display:inline" value="Save as TSV" onclick="submitExcel('text/tab-separated-values');" alt="SaveAsTSV"/></td>
							<td><input type="button" style="width:150;height:30;display:inline" value="Reset" onclick="resetSearchCriteria();" alt="Reset"/></td>
							</tr> 
							</table>  
					     </div>		        
			            <div id="supportingText">
			               <div id="dateRange">
				             <h1>Transactions - <%= fromDateParam %> to <%= toDateParam %></h1>
				           </div>
				          <div id="navigation">
				          <table border="0" cellspacing="0">
				           <tr>
						       <td><input id="vcrRewind" type="button" style="width:25;height:20;display:inline" value="&lt&lt" onclick="firstPage();" alt="First Page"/></td>
                               <td><input id="vcrPrevPage" type="button" style="width:25;height:20;display:inline" value="|&lt" onclick="previousPage();" alt="Previous Page"/></td>
					           <td><input id="vcrNextPage" type="button" style="width:25;height:20;display:inline" value="&gt|" onclick="nextPage();" alt="Next Page"/></td>
					       </tr>
				          </table>
				         </div> 
				      <!-- start of inner wrap, 7-15-09 -->      
				     <div class="innerwrap"> 
				      <table>
					   <tr>
						<th>Date and Time</th>
						<th>Time on ViX (msec)</th>
						<th>ICN</th>
						<th>Query Type</th>
						<th>Query Filter</th>
						<th>Asynchronous?</th>
						<th>Items Returned</th>
						<th>Items Received</th>
						<th>Bytes Returned</th>
						<th>Bytes Received</th>
						<th>Throughput (KB/sec)</th>
						<th>Quality</th>
						<th>Command Class Name</th>
						<th>Originating IP Address</th>
						<th>User</th>
						<th>Item in cache?</th>
						<th>Error Message</th>
						<th>Modality</th>
						<th>Purpose of Use</th>
						<th>Datasource Protocol</th>
						<th>Response Code</th>		
						<th>Realm Site Number</th>				
						<th>URN</th>
                        <th>Transaction Number</th>
                        <th>Vix Software Version</th>
                        <th>VistA Login Method</th>
                        <th>Client Version</th>
                        <th>Data Source Method</th>
                        <th>Data Source Version</th>
                        <th>Data Source Response Server</th>
                        <th>VIX Site Number</th>
                        <th>Requesting VIX Site Number</th>
                        <%
                        	if(debug)
                        	{
                        		out.print("<th>Thread ID</th>");
                        		out.print("<th>Debug Information</th>");                        		
                       		}
                         %>
					   </tr>
					<log:TransactionLog 
						startDate="<%= fromDate %>"
						endDate="<%= toDate %>"
						quality="<%= imageQuality %>"
						user="<%= user %>"
						modality="<%= modality %>"
						datasourceProtocol="<%= datasourceProtocol %>"
						errorMessage="<%= errorMessage %>"
						transactionId="<%= transactionId  %>"
						imageUrn="<%= imageUrn %>"
						startIndex="<%= startIndex %>"
						endIndex="<%= endIndex %>"
						forward="<%= forwardIteration %>" 
						emptyResultMessage="No transaction log entries."
						byteTransferPath="<%= byteTransferPath %>">
						<log:TransactionLogEntries>
							<tr>
								<log:TransactionLogEntry>
									<td><log:TransactionLogEntryStartTime dateFormatPattern="MM/dd/yyyy hh:mm:ss a"/>&nbsp;</td>
									<td><log:TransactionLogEntryElapsedTime/>&nbsp;</td>
									<td><log:TransactionLogEntryPatientICN/>&nbsp;</td>
									<td><log:TransactionLogEntryQueryType/>&nbsp;</td>
									<td><log:TransactionLogEntryQueryFilter/>&nbsp;</td>
									<td><log:TransactionLogEntryAsynchronousCommand/>&nbsp;</td>
									<td><log:TransactionLogEntryItemCount/>&nbsp;</td>
									<td><log:TransactionLogEntryReceivedCount/>&nbsp;</td>
									<c:choose>
									  <c:when test="${byteTransferPath == ByteTransferPath.DS_IN_FACADE_OUT}">
    									<td><log:TransactionLogEntryBytesTransferred byteTransferType="<%= ByteTransferType.FACADE_BYTES_SENT %>"/>&nbsp;</td>
									    <td><log:TransactionLogEntryBytesTransferred byteTransferType="<%= ByteTransferType.DATASOURCE_BYTES_RECEIVED %>"/>&nbsp;</td>
									    <td><log:TransactionLogEntryImageThroughput byteTransferType="<%= ByteTransferType.FACADE_BYTES_SENT %>"/>&nbsp;</td>
									  </c:when>
									  <c:otherwise>
    									<td><log:TransactionLogEntryBytesTransferred byteTransferType="<%= ByteTransferType.DATASOURCE_BYTES_SENT %>"/>&nbsp;</td>
									    <td><log:TransactionLogEntryBytesTransferred byteTransferType="<%= ByteTransferType.FACADE_BYTES_RECEIVED %>"/>&nbsp;</td>
									    <td><log:TransactionLogEntryImageThroughput byteTransferType="<%= ByteTransferType.FACADE_BYTES_RECEIVED %>"/>&nbsp;</td>
									  </c:otherwise>
									</c:choose>
									<td><log:TransactionLogEntryQuality/>&nbsp;</td>
									<td><log:TransactionLogEntryCommandClassName/>&nbsp;</td>
									<td><log:TransactionLogEntryOriginatingHost/>&nbsp;</td>
									<td><log:TransactionLogEntryUser/>&nbsp;</td>
									<td><log:TransactionLogEntryCacheHit/>&nbsp;</td>
									<td><log:TransactionLogEntryErrorMessage/>&nbsp;</td>
									<td><log:TransactionLogEntryModality/>&nbsp;</td>
									<td><log:TransactionLogEntryPurposeOfUse/>&nbsp;</td>
									<td><log:TransactionLogEntryDatasourceProtocol/>&nbsp;</td>
									<td><log:TransactionLogEntryResponseCode/>&nbsp;</td>									
									<td><log:TransactionLogEntryRealmSiteNumber/>&nbsp;</td>								
									<td><log:TransactionLogEntryURN/>&nbsp;</td>
									<td>
										<% if(debug) 
										{
											%>
											<a href="VixLogViewTransaction.jsp?transactionId=<log:TransactionLogEntryTransactionID/>"><log:TransactionLogEntryTransactionID/></a>
											<%
										}
										else
										{
										%>
											<log:TransactionLogEntryTransactionID/>&nbsp;
										<% 
										} 
										%>
									</td>
                           			<td><log:TransactionLogEntryVixSoftwareVersion/>&nbsp;</td>						
									<td><log:TransactionLogEntryRemoteLoginMethod/>&nbsp;</td>
									<td><log:TransactionLogEntryClientVersion/>&nbsp;</td>
									<td><log:TransactionLogEntryDataSourceMethod/>&nbsp;</td>
									<td><log:TransactionLogEntryDataSourceVersion/>&nbsp;</td>
									<td><log:TransactionLogEntryDataSourceResponseServer/>&nbsp;</td>
									<td><log:TransactionLogEntryVixSiteNumber/>&nbsp;</td>
									<td><log:TransactionLogEntryRequestingVixSiteNumber/>&nbsp;</td>
									<%
										if(debug)
										{
											%>
											<td><log:TransactionLogEntryThreadId/>&nbsp;</td>
											<td><log:TransactionLogEntryDebugInformation/>&nbsp;</td>
											<%
										}
									 %>
								</log:TransactionLogEntry>
							</tr>
						</log:TransactionLogEntries>
					</log:TransactionLog>	
				</table>
				
				<%
					try
					{
						SimpleDateFormat sdf = new SimpleDateFormat("MMMM d, yyyy h:mm:ss.SSSS a z");
						Calendar now = Calendar.getInstance();
						out.print("Current time on VIX: " + sdf.format(now.getTime()));
					}
					catch(Exception ex) {}
				 %>
				
			</div>
		</div>
		</form>
		</div> <!-- end of innerwrap, 7-15-09 -->

		<table border="0" cellspacing="0">
			<tr>
				<td>
					<input id="vcrRewind2" type="button"
						style="width: 25; height: 20; display: inline" value="&lt&lt"
						onclick="firstPage();" alt="First Page" />
				</td>
				<td>
					<input id="vcrPrevPage2" type="button"
						style="width: 25; height: 20; display: inline" value="|&lt"
						onclick="previousPage();" alt="Previous Page" />
				</td>
				<td>
					<input id="vcrNextPage2" type="button"
						style="width: 25; height: 20; display: inline" value="&gt|"
						onclick="nextPage();" alt="Next Page" />
				</td>
			</tr>
		</table>


		<c:choose>
			<c:when test='<%= (Boolean)pageContext.getAttribute("hasPreviousPage") == false %>'>
				<script>
				document.all.vcrRewind.disabled = 'disabled';
				document.all.vcrPrevPage.disabled = 'disabled';
				document.all.vcrRewind2.disabled = 'disabled';
				document.all.vcrPrevPage2.disabled = 'disabled';
				</script>
			</c:when>
		</c:choose>
		<c:choose>
			<c:when test='<%= (Boolean)pageContext.getAttribute("hasNextPage") == false %>'>
				<script>
				document.all.vcrNextPage.disabled = 'disabled';
				document.all.vcrNextPage2.disabled = 'disabled';
				</script>
			</c:when>
		</c:choose>	
		<div id="pageFooter">
			<jsp:include flush="false" page="../footer.html"></jsp:include>
		</div>		
      <script src="../script/boxover.js"></script>
	</body>
</html>
