package gov.va.med.imaging.dicom.io;

import gov.va.med.imaging.dicom.DataSet;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.IncompatibleValueLengthField;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.io.IOException;
import java.io.InputStream;

/**
 * 
 * @author vhaiswbeckec
 *
 */
public class TestPart10DataSetLoader 
extends AbstractDataSetReadTest
{
	@Override
    protected void setUp() throws Exception
    {
	    super.setUp();
	    this.setWriteToFile(true);
    }

	public void testLoadFile_brain_001() 
	throws 
		UnsupportedOperationException, 
		IOException, 
		DicomFormatException, InvalidVRModeException, InvalidVRException, 
		ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
		RawPixelInterpretationValuesNotSetException
	{
		rolloverNewLogFile("brain_001.dcm");
		loadFile("images/brain_001.dcm");
	}
	
	public void testLoadFile_brain_002() 
	throws 
		UnsupportedOperationException, 
		IOException, 
		DicomFormatException, InvalidVRModeException, InvalidVRException, 
		ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
		RawPixelInterpretationValuesNotSetException
	{
		rolloverNewLogFile("brain_002.dcm");
		loadFile("images/brain_002.dcm");
		
	}		
//	public void testLoadFile_200_CT2_90() 
//	throws 
//		UnsupportedOperationException, 
//		IOException, 
//		DicomFormatException, InvalidVRModeException, InvalidVRException, 
//		ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
//		RawPixelInterpretationValuesNotSetException
//	{
//		rolloverNewLogFile("200-CT2-90.dcm");
//		loadFile("images/200-CT2-90.dcm");
//		
//	}		
//	public void testLoadFile_unitTestDCM() 
//	throws 
//		UnsupportedOperationException, 
//		IOException, 
//		DicomFormatException, InvalidVRModeException, InvalidVRException, 
//		ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
//		RawPixelInterpretationValuesNotSetException
//	{
//		rolloverNewLogFile("unitTestDCM.dcm");
//		loadFile("images/unitTestDCM.dcm");
//		
//	}		
//	public void testLoadFile_unitTestL10() 
//	throws 
//		UnsupportedOperationException, 
//		IOException, 
//		DicomFormatException, InvalidVRModeException, InvalidVRException, 
//		ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
//		RawPixelInterpretationValuesNotSetException
//	{
//		rolloverNewLogFile("unitTestL10.dcm.j2k");
//		loadFile("images/unitTestL10.dcm.j2k");
//		
//	}		
//	public void testLoadFile_unitTestLL() 
//	throws 
//		UnsupportedOperationException, 
//		IOException, 
//		DicomFormatException, InvalidVRModeException, InvalidVRException, 
//		ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
//		RawPixelInterpretationValuesNotSetException
//	{
//		rolloverNewLogFile("unitTestLL.dcm.j2k");
//		loadFile("images/unitTestLL.dcm.j2k");
//	}

	private void loadFile(String resourceName)
	throws 
		UnsupportedOperationException, 
		IOException, 
		DicomFormatException, InvalidVRModeException, InvalidVRException, 
		ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
		RawPixelInterpretationValuesNotSetException
	{
		System.out.println("Loading file '" + resourceName + "'");
		InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
		DataSet dataSet = Part10DataSetLoader.load( inStream );
		assertNotNull(dataSet);
		
		assertNotNull( dataSet.getImageFrames() );
	}
}
