/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author vhaiswbeckec
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.io;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import junit.framework.TestCase;

/**
 * @author vhaiswbeckec
 *
 */
public abstract class AbstractDataSetReadTest 
extends TestCase
{
	private boolean writeToFile = false;
	
	protected boolean isWriteToFile()
    {
    	return writeToFile;
    }

	protected void setWriteToFile(boolean writeToFile)
    {
    	this.writeToFile = writeToFile;
    }

	protected void rolloverNewLogFile(String identifier) 
	throws SecurityException, IOException
	{
		if(! isWriteToFile())
			return;
		
		String userHomeDirName = System.getenv("user.home");
		if(userHomeDirName == null)
			userHomeDirName = "/";
		String testDirName = userHomeDirName + "dicom_read_tests";
		File testDir = new File(testDirName);
		testDir.mkdirs();
		
	    Handler newHandler = new FileHandler(testDirName + "/" + identifier + ".log");
	    newHandler.setFormatter( new SimpleTextFormatter() );
	    Logger logger = Logger.getLogger("gov.va.med");
	    
	    for(Handler handler : logger.getHandlers() )
	    {
	    	if(handler instanceof FileHandler)
	    	{
	    		logger.removeHandler(handler);
	    		handler.close();
	    	}
	    }
	    
	    logger.addHandler(newHandler);
	}
	
	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception
	{
		super.setUp();
		
	    Handler handler = isWriteToFile() ? new FileHandler("%h/tests/DataSetRead%u.log") : new ConsoleHandler();
	    handler.setLevel (Level.WARNING);
	    handler.setFormatter( new SimpleTextFormatter() );
	    
	    Logger logger = Logger.getLogger("gov.va.med");
		logger.addHandler (handler);

		logger.setLevel (Level.WARNING);		
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception
	{
		super.tearDown();
	}

	
    class SimpleTextFormatter extends Formatter
    {
    	private DateFormat df = new SimpleDateFormat("hh:mm:ss");
    	
		@Override
        public String format(LogRecord record)
        {
			StringBuffer sb = new StringBuffer();

			sb.append("[Thread-");
			sb.append(record.getThreadID());
			sb.append(']');
			sb.append( df.format(new Date(record.getMillis())) );
			sb.append(' ');
			sb.append(record.getSourceClassName());
			sb.append('.');
			sb.append(record.getSourceMethodName());
			sb.append(" \"");
			sb.append(record.getMessage());
			sb.append('\"');
			sb.append(System.getProperty("line.separator"));
			
			return sb.toString();
        }
    	
    }
}
