/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 13, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import gov.va.med.imaging.dicom.DataSet;
import gov.va.med.imaging.dicom.TransferSyntaxUid;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.IncompatibleValueLengthField;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;
import gov.va.med.imaging.dicom.io.Part10DataSetLoader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/**
 * ---------------------------------------------------------------- 
 * Package: MAG - VistA Imaging WARNING: Per VHA Directive 2004-038, this
 * routine should not be modified. Date Created: May 15, 2008 Site Name:
 * Washington OI Field Office, Silver Spring, MD
 * 
 * Property
 * of the US Government. No permission to copy or redistribute this software
 * is given. Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging Development
 * Office of the Department of Veterans Affairs, telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as a Class II
 * medical device. As such, it may not be changed in any way. Modifications
 * to this software may result in an adulterated medical device under
 * 21CFR820, the use of which is considered to be a violation of US Federal
 * Statutes.
 * ----------------------------------------------------------------
 * 
 * @author DNS
 * 
 */
public class ViewerFrame 
extends JFrame
{
	private static final long serialVersionUID = 1L;
	
	private Action setSecurityContextAction;
	private Action urlOpenAction;
	private Action fileOpenAction;
	private Action fileCloseAction;
	private Action fileCloseAllAction;
	private Action fileExitAction;
	public Action helpAboutAction;
	
	private JDesktopPane imagePane;
	private StatusPanel status;

	//A file chooser, if not running in an applet
	private final JFileChooser fileChooser;
	
	private boolean runningInApplet;
	
	public ViewerFrame(boolean runningInApplet)
	{
		this.runningInApplet = runningInApplet;
		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

		if(! isRunningInApplet())
			fileChooser = new JFileChooser();
		else
			fileChooser = null;
		
		initActions();
		initMenu();
		initGui();
	}
	
	public boolean isRunningInApplet()
	{
		return runningInApplet;
	}
	
	/**
	 * 
	 */
	private void initActions()
    {
		if(! isRunningInApplet())
		{
			setSecurityContextAction = new AbstractAction("Set Security Context...")
		    {
				private static final long serialVersionUID = 1L;
				@Override
	            public void actionPerformed(ActionEvent e)
	            {
					userInteractionSetUserSecurityContext();
	            }
		    };
		    
		    fileOpenAction = new AbstractAction("Open...")
		    {
				private static final long serialVersionUID = 1L;
				@Override
	            public void actionPerformed(ActionEvent e)
	            {
					userInteractionOpenImageFile();
	            }
		    };
		    
		    fileCloseAction = new AbstractAction("Close")
		    {
				private static final long serialVersionUID = 1L;
				@Override
	            public void actionPerformed(ActionEvent e)
	            {
					close();
	            }
		    };

		    fileCloseAllAction = new AbstractAction("Close All")
		    {
				private static final long serialVersionUID = 1L;
				@Override
	            public void actionPerformed(ActionEvent e)
	            {
					closeAll();
	            }
		    };

		    fileExitAction = new AbstractAction("Exit")
		    {
				private static final long serialVersionUID = 1L;
				@Override
	            public void actionPerformed(ActionEvent e)
	            {
					exit();
	            }
		    };
		}
		else
		{
			fileOpenAction = null;
			fileCloseAction = null;
			fileExitAction = null;
		}
		
		urlOpenAction = new AbstractAction("Open URL...")
	    {
			private static final long serialVersionUID = 1L;
			@Override
            public void actionPerformed(ActionEvent e)
            {
				userInteractionOpenImageUrl();
            }
	    };
	    
	    helpAboutAction = new AbstractAction("About...")
	    {
			private static final long serialVersionUID = 1L;
			@Override
            public void actionPerformed(ActionEvent e)
            {
            }
	    };
    }
	
	/**
	 * 
	 */
	private void initMenu()
    {
		this.setJMenuBar(new ViewerFrame.Menu(this));
    }
	
	private void initGui()
    {
		this.setLayout(new BorderLayout());
		
		this.status = new StatusPanel(this);
		add(this.status, BorderLayout.SOUTH);
		
		imagePane = new JDesktopPane();
		imagePane.setPreferredSize( new Dimension(800, 600) );
		add(this.imagePane, BorderLayout.CENTER);
		
		this.pack();
    }

	/**
	 * 
	 */
	protected void userInteractionSetUserSecurityContext()
    {
		String userId = null;
		String password = null;
		
		userId = (String)JOptionPane.showInputDialog(this, "User ID (access code)", "Security Context",
                JOptionPane.PLAIN_MESSAGE, null, null, null);
		if(userId != null)
		{
			password = (String)JOptionPane.showInputDialog(this, "User password (verify code)", "Security Context",
	                JOptionPane.PLAIN_MESSAGE, null, null, null);
			
			setSecurityContext(userId, password);
		}
    }

	/**
	 * 
	 */
	protected void userInteractionOpenImageFile()
    {
		//In response to a button click:
		switch( fileChooser.showOpenDialog(this) )
		{
		case JFileChooser.APPROVE_OPTION:
			File selectedFile = fileChooser.getSelectedFile();
			status.setStatus( "Opening " + selectedFile.getName() );
			try
			{
                showImage(selectedFile);
    			status.setStatus( "Opened " + selectedFile.getName() );
            } 
			catch (Exception e)
            {
                e.printStackTrace();
    			status.setStatus( "Error opening '" + selectedFile.getName() + "', " + e.getMessage() );
            }
			break;
		case JFileChooser.CANCEL_OPTION:
			break;
		case JFileChooser.ERROR_OPTION:
			break;
		}
    }

	/**
	 * 
	 */
	protected void userInteractionOpenImageUrl()
    {
		Object[] possibilities = null;
		String imageUrlAsString = (String)JOptionPane.showInputDialog(
                this,
                "URL to open:",
                "Open Image from URL",
                JOptionPane.QUESTION_MESSAGE,
                null,
                possibilities,
                "http://DNS.URL       /Vix/secure/diagnostic/");
		
		try
        {
	        if(imageUrlAsString != null)
	        {
	        	URL imageUrl = new URL(imageUrlAsString);
	        	showImage(imageUrl);
	        }
        }
		catch (MalformedURLException e)
        {
	        e.printStackTrace();
        }
		catch (Exception e)
        {
	        e.printStackTrace();
        }
    }
	
	/**
	 * 
	 */
	private void close()
    {
	    //this.close();
    }

	public void closeAll()
    {
		List<Component> deadMenWalking = new ArrayList<Component>();
		for( Component component : this.imagePane.getComponents() )
			if(component instanceof JInternalFrame)
			{
				component.setVisible(false);
				deadMenWalking.add(component);
			}
		
		for(Component deadManWalking : deadMenWalking)
			this.imagePane.remove(deadManWalking);
    }
	
	/**
	 * returns true if any images are displayed, else false
	 * this is used by the driving applet to determine whether the frame
	 * should be visible on start()
	 * @return
	 */
	public boolean isDisplayingImages()
	{
		for( Component component : this.imagePane.getComponents() )
			if(component instanceof JInternalFrame)
				return true;
		return false;
	}
	
	/**
	 * 
	 */
	private void exit()
    {
	    //this.close();
    }
	
	/**
	 * 
	 * @param imageLocator
	 */
	public void showImage(String imageLocator)
	{
		status.setStatus("Opening image '" + imageLocator + "'.");
		
		try
        {
			// first, determine if the locator is a URL or a filename
			// if it can be parsed as a URL then assume it is a URL
			URL imageUrl = null;
			try {imageUrl = new URL(imageLocator); }
			catch(MalformedURLException muX){imageUrl = null;}
			
			if(imageUrl != null)
			{
				status.setStatus("Opening URL '" + imageUrl.toString() + ".");
	            showImage(imageUrl);
				status.setStatus("Opened URL '" + imageUrl.toString() + ".");
			}
			else
			{
				status.setStatus("Opening image '" + imageLocator + "' as file.");
				File imageFile = new File(imageLocator);
				status.setStatus("Opening file '" + imageLocator + "'.");
				showImage(imageFile);
				status.setStatus("Opened file:" + imageLocator);
			}
        } 
		catch (MalformedURLException e)
        {
            e.printStackTrace();
			status.setStatus(e.getMessage());
        } 
		catch (Exception e)
        {
			e.printStackTrace();
			status.setStatus(e.getMessage());
        }
	}

	/**
	 * 
	 * @param imageUrl
	 * @throws IOException 
	 * @throws InvalidVRException 
	 * @throws InvalidVRModeException 
	 * @throws DicomFormatException 
	 * @throws IncompatibleValueLengthField 
	 * @throws ValueRepresentationInterpretationException 
	 * @throws UnsupportedOperationException 
	 * @throws RawPixelInterpretationValuesNotSetException 
	 */
	public void showImage(URL imageUrl) 
	throws UnsupportedOperationException, ValueRepresentationInterpretationException, IncompatibleValueLengthField, DicomFormatException, InvalidVRModeException, InvalidVRException, IOException, RawPixelInterpretationValuesNotSetException
    {
		status.setStatus("Opening URL:" + imageUrl.toString());
		BufferedDicomImage dicomImage = openDicom(imageUrl);
		displayNewImage(dicomImage.getDataSet(), imageUrl.toString(), dicomImage.getWrappedImage());
		status.setStatus("Opened URL:" + imageUrl.toString());
    }
	
	/**
	 * 
	 * @param imageFile
	 * @throws IOException 
	 * @throws InvalidVRException 
	 * @throws InvalidVRModeException 
	 * @throws DicomFormatException 
	 * @throws IncompatibleValueLengthField 
	 * @throws ValueRepresentationInterpretationException 
	 * @throws UnsupportedOperationException 
	 * @throws RawPixelInterpretationValuesNotSetException 
	 */
	public void showImage(File imageFile) 
	throws UnsupportedOperationException, ValueRepresentationInterpretationException, IncompatibleValueLengthField, 
		DicomFormatException, InvalidVRModeException, InvalidVRException, IOException, RawPixelInterpretationValuesNotSetException
	{
		String pathName = imageFile.getPath(); 
		int indexOfExtension = pathName.lastIndexOf('.');
		if(indexOfExtension >= 0)
		{
			String extension = pathName.substring(indexOfExtension+1);
			if("dcm".equalsIgnoreCase(extension))
			{
				BufferedDicomImage dicomImage = openDicomFile(imageFile);
				if(dicomImage != null)
					displayNewImage(dicomImage.getDataSet(), imageFile.getName(), dicomImage.getWrappedImage());
			}
			else
			{
				BufferedImage image = openImageIOImage(imageFile);
				if(image != null)
					displayNewImage(null, imageFile.getName(), image);
			}
		}
		else
		{
			BufferedImage image = openImageIOImage(imageFile);
			displayNewImage(null, imageFile.getName(), image);
		}
	}
	
	/**
	 * 
	 * @param uid
	 * @param pwd
	 */
	public void setSecurityContext(String uid, String pwd)
	{
		SecurityContext.initialize(uid, pwd);
	}

	/**
	 * 
	 * @param imageFile
	 * @return
	 * @throws IOException 
	 */
	private BufferedImage openImageIOImage(File imageFile) 
	throws IOException
    {
	    return ImageIO.read(imageFile);
    }

	private BufferedDicomImage openDicomFile(File imageFile) 
	throws UnsupportedOperationException, ValueRepresentationInterpretationException, IncompatibleValueLengthField, DicomFormatException, InvalidVRModeException, InvalidVRException, IOException, RawPixelInterpretationValuesNotSetException
	{
		DataSet dataSet = Part10DataSetLoader.load( imageFile );
		
		return showDicomImage(dataSet);
	}

	private BufferedDicomImage openDicom(URL imageUrl) 
	throws UnsupportedOperationException, ValueRepresentationInterpretationException, IncompatibleValueLengthField, DicomFormatException, InvalidVRModeException, InvalidVRException, IOException, RawPixelInterpretationValuesNotSetException
	{
		DataSet dataSet = Part10DataSetLoader.load( imageUrl );
		
		return showDicomImage(dataSet);
	}
	
	/**
     * @param dataSet
     * @return
     * @throws DicomFormatException
     * @throws IOException
     * @throws InvalidVRModeException
     * @throws InvalidVRException
	 * @throws RawPixelInterpretationValuesNotSetException 
     */
    private BufferedDicomImage showDicomImage(DataSet dataSet) 
    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
    {
    	if(dataSet == null)
    		return null;
    	
	    TransferSyntaxUid transferSyntax = dataSet.getTransferSyntax();
		String imageMimeType = transferSyntax.getMimeType();
		
		System.out.println("Dicom data set using transfer syntax '" + dataSet.getTransferSyntax() + "'.");
		BufferedImage image = dataSet.getFirstImage();
		
		return new BufferedDicomImage(dataSet, image );
    }
	
	/**
	 * 
	 * @param newImage
	 */
	private void displayNewImage(DataSet dataSet, String title, BufferedImage newImage)
    {
		DicomPropertiesDialog childImageFrame = new DicomPropertiesDialog(dataSet);
		childImageFrame.setPreferredSize(new Dimension(800, 600));
		
		childImageFrame.pack();
		childImageFrame.setVisible(true);
		try{childImageFrame.setSelected(true);}
		catch(PropertyVetoException pvX){}
		
		this.imagePane.add(childImageFrame);
    }

	class Menu extends JMenuBar
	{
		private static final long serialVersionUID = 1L;
		
		Menu(ViewerFrame parentFrame)
		{
			JMenu fileMenu = new JMenu("File");
			JMenu viewMenu = new JMenu("View");
			JMenu helpMenu = new JMenu("Help");
			
			if(setSecurityContextAction != null)
				fileMenu.add(new JMenuItem(parentFrame.setSecurityContextAction));
			if(fileOpenAction != null)
				fileMenu.add(new JMenuItem(parentFrame.fileOpenAction));
			if(urlOpenAction != null)
				fileMenu.add(new JMenuItem(parentFrame.urlOpenAction));
			if(fileCloseAction != null)
				fileMenu.add(new JMenuItem(parentFrame.fileCloseAction));
			if(fileCloseAllAction != null)
				fileMenu.add(new JMenuItem(parentFrame.fileCloseAllAction));
			if(fileExitAction != null)
				fileMenu.add(new JMenuItem(parentFrame.fileExitAction));
			
			JMenuItem helpAboutItem = new JMenuItem(parentFrame.helpAboutAction);
			
			helpMenu.add(helpAboutItem);

			if(fileMenu.getMenuComponentCount() > 0)
				this.add(fileMenu);
			
			this.add(viewMenu);
			this.add(helpMenu);
		}
	}
	
	class StatusPanel 
	extends JPanel 
	{
		private static final long serialVersionUID = 1L;
		private JLabel statusLabel;
		
		void setStatus(String status)
		{
			statusLabel.setText(status);
		}
		
		StatusPanel(ViewerFrame parentFrame)
		{
			this.setLayout(new BorderLayout());
			statusLabel = new JLabel("Initializing ...");
			this.add(statusLabel, BorderLayout.CENTER);
		}
	}

}
