/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 15, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.*;

/**
 * @author       DNS
 *
 */
public class ViewerApplication
{
	private static ViewerFrame frame;
	private static GraphicsEnvironment gv;
	private static GraphicsDevice defaultDevice;
	
	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
	    Handler handler = new ConsoleHandler();
	    handler.setLevel (Level.WARNING);
	    handler.setFormatter( new SimpleTextFormatter() );
	    
	    Logger logger = Logger.getLogger("gov.va.med");
		logger.addHandler (handler);

		logger.setLevel (Level.WARNING);		

		gv = GraphicsEnvironment.getLocalGraphicsEnvironment();
		defaultDevice = gv.getDefaultScreenDevice();

		frame = new ViewerFrame(false);
		//frame.setIgnoreRepaint(true);
		//frame.setUndecorated(true);
		//frame.setResizable(false);
		frame.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e)
			{
				System.exit(0);
			}
		});

		try
		{
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run()
				{
					//defaultDevice.setFullScreenWindow(frame);
					frame.setVisible(true);
				}
			});
		} 
		finally
		{
			defaultDevice.setFullScreenWindow(null);
		}
	}

    static class SimpleTextFormatter extends Formatter
    {
    	private DateFormat df = new SimpleDateFormat("hh:mm:ss");
    	
		@Override
        public String format(LogRecord record)
        {
			StringBuffer sb = new StringBuffer();

			sb.append("[Thread-");
			sb.append(record.getThreadID());
			sb.append(']');
			sb.append( df.format(new Date(record.getMillis())) );
			sb.append(' ');
			sb.append(record.getSourceClassName());
			sb.append('.');
			sb.append(record.getSourceMethodName());
			sb.append(" \"");
			sb.append(record.getMessage());
			sb.append('\"');
			sb.append(System.getProperty("line.separator"));
			
			return sb.toString();
        }
    	
    }

}
