package gov.va.med.imaging.dicomviewer;

import java.applet.Applet;
import java.util.ArrayList;
import java.util.List;

public class ViewerAppletParameter
{
	public final static String IMAGE_URL_PATTERN = "imageURL#"; 
	public final static String IDENTITY = "identity"; 
	public final static String CREDENTIALS = "credentials"; 
	
	private final Applet parentApplet;
	public ViewerAppletParameter(Applet parentApplet)
    {
		this.parentApplet = parentApplet;
    }
	
	/**
     * @return the parentApplet
     */
    public Applet getParentApplet()
    {
    	return parentApplet;
    }

	public String[][] getParameterInfo()
	{
		String[][] pinfo =
		{
			{ IMAGE_URL_PATTERN, "String", "A Image URL, where # is substituted for a monotonicaly increasing 1-based series of integers." }, 
			{ IDENTITY, "String", "The user identity to use when authenticating" }, 
			{ CREDENTIALS, "String", "The user credentials to use when authenticating" }
		};
		return pinfo;
	}
	
	public String getParameter(String key, String def)
	{
		String paramString;
		paramString = getParentApplet().getParameter(key) != null ? getParentApplet().getParameter(key) : def;

		return paramString;
	}

	public Integer getParameterAsInteger(String key, Integer defaultValue)
	{
		String paramString = getParentApplet().getParameter(key);

		try{ return paramString == null ? defaultValue :new Integer(paramString); }
		catch(NumberFormatException nfX){return defaultValue;}
	}
	
	public Long getParameterAsLong(String key, Long defaultValue)
	{
		String paramString = getParentApplet().getParameter(key);

		try{ return paramString == null ? defaultValue : new Long(paramString); }
		catch(NumberFormatException nfX){return defaultValue;}
	}
	
	public Float getParameterAsFloat(String key, Float defaultValue)
	{
		String paramString = getParentApplet().getParameter(key);

		try{ return paramString == null ? defaultValue : new Float(paramString); }
		catch(NumberFormatException nfX){return defaultValue;}
	}
	
	public Double getParameterAsDouble(String key, Double defaultValue)
	{
		String paramString = getParentApplet().getParameter(key);

		try{ return paramString == null ? defaultValue : new Double(paramString); }
		catch(NumberFormatException nfX){return defaultValue;}
	}

	/**
	 * 
	 * @param regex
	 * @param defaultValue
	 * @return
	 */
	public String[] getParametersAsStringArray(String pattern)
	{
		List<String> values = new ArrayList<String>();
		int serialNumberIndex = pattern.indexOf("#");
		String parameterPrefix = pattern.substring(0, serialNumberIndex);
		for(int index=1; true; ++index)
		{
			String key = parameterPrefix + Integer.toString(index);
			if(pattern.length() > serialNumberIndex)
				key += pattern.substring(serialNumberIndex+1);
			String paramValue = getParentApplet().getParameter(key);
			if(paramValue == null)
				break;
			values.add(paramValue);
		}
		
		return values.toArray(new String[values.size()]);
	}
}
