/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 18, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import java.applet.Applet;
import java.awt.HeadlessException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author       DNS
 *
 */
public class ViewerApplet 
extends Applet
{
	private static final long serialVersionUID = 2L;
	private ViewerAppletParameter parameters;
	private ViewerFrame frame;
	private Logger logger;
	
	/**
	 * @throws HeadlessException
	 */
	public ViewerApplet() 
	throws HeadlessException
	{
		logger = Logger.getLogger(this.getClass().getName());
		
		frame = new ViewerFrame(true);
		
		//java.awt.EventQueue.invokeLater(new Runnable() {
		//	public void run()
		//	{
		//		//defaultDevice.setFullScreenWindow(frame);
		//		frame.setVisible(true);
		//	}
		//});
	}

	@Override
    public void init()
    {
	    super.init();
		parameters = new ViewerAppletParameter(this);
		
		String userIdentification = parameters.getParameter(ViewerAppletParameter.IDENTITY, null);
		String userCredentials = parameters.getParameter(ViewerAppletParameter.CREDENTIALS, null);

		if(userIdentification != null)
			frame.setSecurityContext(userIdentification, userCredentials);
		
		String[] imageUrls = parameters.getParametersAsStringArray(ViewerAppletParameter.IMAGE_URL_PATTERN);
		
		for(String imageUrlAsString : imageUrls)
			openImage(imageUrlAsString);
    }

	/**
	 * 
	 * @param userIdentification
	 * @param userCredentials
	 */
	public void setSecurityContext(String userIdentification, String userCredentials)
    {
		SecurityContext.initialize(userIdentification, userCredentials);
    }
	
	@Override
    public void start()
    {
	    super.start();
	    if(frame.isDisplayingImages())
	    	frame.setVisible(true);
    }

	/**
	 * 
	 * @param imageUrlAsString
	 */
	public void openImage(String imageUrlAsString)
	{
		logger.log(Level.FINE, "Opening '" + imageUrlAsString + "'.");
		frame.showImage(imageUrlAsString);
	    frame.setVisible(true);
	}

	public void closeAllImage()
	{
		frame.closeAll();
	}
	
	@Override
    public void stop()
    {
	    frame.setVisible(false);
	    super.stop();
    }

	@Override
    public void destroy()
    {
		setSecurityContext(null, null);
	    super.destroy();
    }

}
