package gov.va.med.imaging.dicomviewer;

import org.opensource.Base64;

public class SecurityContext
{
	private static SecurityContext singleton = null;
	
	public static synchronized SecurityContext initialize()
    {
	    singleton = new SecurityContext();
	    return singleton;
    }
	
	public static synchronized SecurityContext initialize(String identity, String credentials)
    {
	    singleton = new SecurityContext(identity, credentials);
	    return singleton;
    }
	
	public static SecurityContext get()
	{
		return singleton;
	}
	
	private final String identity; 
	private final String credentials;

	private SecurityContext(String identity, String credentials)
    {
	    super();
	    this.identity = identity;
	    this.credentials = credentials;
    }
	
	private SecurityContext()
    {
	    super();
	    this.identity = null;
	    this.credentials = null;
    }

	/**
     * @return the identity
     */
    public String getIdentity()
    {
    	return identity;
    }

	/**
     * @return the credentials
     */
    public String getCredentials()
    {
    	return credentials;
    }
    
    public String getAsBase64()
    {
	    String encodedAuthorization = null;
	    if(getIdentity() != null)
	    {
	    	if(getCredentials() != null)
	    		encodedAuthorization = getIdentity() + ":" + getCredentials();
	    	else
	    		encodedAuthorization = getIdentity() + ":";
	    	
	    	encodedAuthorization = new String( Base64.encodeBytes(encodedAuthorization.getBytes()) );
	    	//encodedAuthorization = "Ym9hdGluZzE6Ym9hdGluZzEu";
	    }
	    return encodedAuthorization;
    }
}
